import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse } from '@/types';

type Admin = {
  email: string;
  phone_number: string;
  avatar: string;
  first_name: string;
  last_name: string;
};

export const getAdminProfile = (): Promise<ApiResponse<Admin>> => {
  return axios.get('admin-api/admin-profile');
};

type QueryFnType = typeof getAdminProfile;

type UseAdminProfileOptions = {
  config?: QueryConfig<QueryFnType>;
};

export const useAdminProfile = ({ config }: UseAdminProfileOptions = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['adminProfile'],
    queryFn: getAdminProfile,
  });
};
