import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, InvestmentCompany } from '@/types';

export const getCompanyInvestmentDetail = (id: string): Promise<ApiResponse<InvestmentCompany>> => {
  return axios.get(`admin-api/investment-company-details?project_id=${id}`);
};

type QueryFnType = typeof getCompanyInvestmentDetail;

type UseBusinessOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useCompanyInvestmentDetail = ({ config, id }: UseBusinessOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['company-investment-detail'],
    queryFn: () => getCompanyInvestmentDetail(id),
  });
};
