import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { FaqContent } from '@/types';
import { TableResponse } from '@/types/TableResponse';

export const getFaq = (pagination: PaginationQuery): Promise<TableResponse<FaqContent>> => {
  return axios.get(url('/admin-api/faq-listing', pagination));
};

type QueryFnType = typeof getFaq;

type UseFaqOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useFaq = ({ config, page_per_data = '10', page }: UseFaqOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['faq-list'],
    queryFn: () => getFaq({ page_per_data, page }),
  });
};
