import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse } from '@/types';
import { useQuery } from 'react-query';

export type LaywerDetailsData = {
  user_type: string;
  first_name: string;
  last_name: string;
  email: string;
  dob: string;
  profile_image: string;
  gender: string;
  address: string;
  nationality: string;
  bio: string;
  image_video: string;
  past_experience: string;
  past_field: string;
  subscription_name: string;
  plan_start_date: string;
  plan_expiry_date: string;
  plan_is_active: string;
  plan_validity: string;
  plan_price: string;
};

export const getLawyerDetails = (id: string): Promise<ApiResponse<LaywerDetailsData>> => {
  return axios.get(`admin-api/lawyer-details?userid=${id}`);
};

type QueryFnType = typeof getLawyerDetails;

type useLawyerDetails = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useLawyerDetails = ({ config, id }: useLawyerDetails = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Laywerdetails'],
    queryFn: () => getLawyerDetails(id),
  });
};
