import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { TableResponse } from '@/types';
import { PaginationQuery } from '@/types/PaginationQuery';
import { useQuery } from 'react-query';
import { formatURL as url } from '@/utils/format';

export type LawyerData = {
  id: string;
  first_name: string;
  last_name: string;
  email: string;
  phone_number: string;
  created_at: string;
};

export const getLawyerList = (pagination: PaginationQuery): Promise<TableResponse<LawyerData>> => {
  return axios.get(url('/admin-api/lawyer-list', pagination));
};

type QueryFnType = typeof getLawyerList;

type useLawyerList = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useLawyerList = ({ config, page_per_data = '10', page }: useLawyerList) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['lawyerlist'],
    queryFn: () => getLawyerList({ page_per_data, page }),
  });
};
