import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, MyDealsAdmin } from '@/types';

export const getMyDealsDetails = (id: string): Promise<ApiResponse<MyDealsAdmin>> => {
  return axios.get(`admin-api/completed-deal-detail?id=${id}`);
};

type QueryFnType = typeof getMyDealsDetails;

type UsePropertyProjectOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useMyDealsDetails = ({ config, id }: UsePropertyProjectOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['mydeals-detail'],
    queryFn: () => getMyDealsDetails(id),
  });
};
