import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { TableResponse } from '@/types/TableResponse';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { PropertyProject } from '@/types';

export const getMyDealsListingAdmin = (
  pagination: PaginationQuery
): Promise<TableResponse<PropertyProject>> => {
  return axios.get(url('admin-api/get-completed-deals', pagination));
};

type QueryFnType = typeof getMyDealsListingAdmin;

type UsePropertyProjectOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useMyDealsListingAdmin = ({
  config,
  page_per_data = '10',
  page,
}: UsePropertyProjectOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['MyDealsListingAdmin'],
    queryFn: () => getMyDealsListingAdmin({ page_per_data, page }),
  });
};
