import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, PropertyforRent } from '@/types';

export const getPropertyForRentDetail = (id: string): Promise<ApiResponse<PropertyforRent>> => {
  return axios.get(`/admin-api/get-rent-property-details?rent_id=${id}`);
};

type QueryFnType = typeof getPropertyForRentDetail;

type UseHousingOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useRentDetails = ({ config, id }: UseHousingOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-for-Rent-detail'],
    queryFn: () => getPropertyForRentDetail(id),
  });
};
