import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { PropertyforRent } from '@/types';
import { TableResponse } from '@/types/TableResponse';

export const getPropertyForRentList = (
  pagination: PaginationQuery
): Promise<TableResponse<PropertyforRent>> => {
  return axios.get(url('/admin-api/get-rent-property', pagination));
};

type QueryFnType = typeof getPropertyForRentList;

type UseHousingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const usePropertyForRent = ({ config, page_per_data = '10', page }: UseHousingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-for-rent'],
    queryFn: () => getPropertyForRentList({ page_per_data, page }),
  });
};
