import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Investment } from '@/types';
import { TableResponse } from '@/types/TableResponse';

export const getPropertyInvestment = (
  pagination: PaginationQuery
): Promise<TableResponse<Investment>> => {
  return axios.get(url('/admin-api/investment-project-list', pagination));
};

type QueryFnType = typeof getPropertyInvestment;

type UseHousingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const usePropertyInvestment = ({
  config,
  page_per_data = '10',
  page,
}: UseHousingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-Investment'],
    queryFn: () => getPropertyInvestment({ page_per_data, page }),
  });
};
// admin-api/investment-project-list
