import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Investment } from '@/types';

export const getPropertyInvestmentDetail = (id: string): Promise<ApiResponse<Investment>> => {
  return axios.get(`admin-api/investment-project-details?project_id=${id}`);
};

type QueryFnType = typeof getPropertyInvestmentDetail;

type UseHousingOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const usePropertyInvestmentDetail = ({ config, id }: UseHousingOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-investment-detail'],
    queryFn: () => getPropertyInvestmentDetail(id),
  });
};
