import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Property } from '@/types';
import { TableResponse } from '@/types/TableResponse';

export const getPropertySaleRentList = (
  pagination: PaginationQuery
): Promise<TableResponse<Property>> => {
  return axios.get(url('/admin-api/get-sale-property', pagination));
};

type QueryFnType = typeof getPropertySaleRentList;

type UseHousingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const usePropertySaleRent = ({ config, page_per_data = '10', page }: UseHousingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['housing'],
    queryFn: () => getPropertySaleRentList({ page_per_data, page }),
  });
};
