import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, RoleContent } from '@/types';

export const getRoleData = (id: string): Promise<ApiResponse<RoleContent>> => {
  return axios.get(`/admin-api/edit-role?id=${id}`);
};

type QueryFnType = typeof getRoleData;

type UsePropertyProjectOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useRoleData = ({ config, id }: UsePropertyProjectOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['roles-detail'],
    queryFn: () => getRoleData(id),
  });
};
