import { axios } from '@/lib/axios';
import { ApiResponse, Subscription } from '@/types';

export type subscriptionDTO = {
  plan_name: string;
  plan_description: string;
  price: string;
  plan_validity: string;
  digital_rental_contract: any;
  notifications_stakeholders: any;
  visibility_among_ads: any;
  visibility_at_top: any;
  information_of_local_area: any;
  tier_type: string;
  package_type: string;
  discount: number;
};

export const postSubscription = (data: subscriptionDTO): Promise<ApiResponse<Subscription>> => {
  return axios.post('/subscription-api/add-plan', data);
};
