import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { InvestorContent } from '@/types/InvestorContent';
import { ApiResponse } from '@/types';

export const getProject = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.get('/admin-api/project-content-page');
};

export const postProject = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.post('/admin-api/project-content-page');
};

type QueryFnType = typeof getProject;

type investorData = {
  config?: QueryConfig<QueryFnType>;
};

export const useProject = ({ config }: investorData = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Investor'],
    queryFn: () => getProject(),
  });
};
