import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, SubAdminData } from '@/types';

export const getRoleData = (id: string): Promise<ApiResponse<SubAdminData>> => {
  return axios.get(`/admin-api/edit-sub-admin?id=${id}`);
};

type QueryFnType = typeof getRoleData;

type UsePropertyProjectOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useRoleData = ({ config, id }: UsePropertyProjectOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['roles-detail'],
    queryFn: () => getRoleData(id),
  });
};
