import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { RoleLists } from '@/types';
import { TableResponse } from '@/types/TableResponse';

export const getUserRoles = (pagination: PaginationQuery): Promise<TableResponse<RoleLists>> => {
  return axios.get(url('/admin-api/sub-admin-listing', pagination));
};

type QueryFnType = typeof getUserRoles;

type UseFaqOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useUserRoles = ({ config, page_per_data = '10', page }: UseFaqOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['userroles-list'],
    queryFn: () => getUserRoles({ page_per_data, page }),
  });
};
