import React, { useEffect } from 'react';
import { Table } from '@/components/Elements';
import { Agency } from '@/types';
import TableLoader from '@/components/Elements/Loader/TableLoader';
import { useNavigate } from 'react-router-dom';
import { useAgencyUsers } from '@/api/agencyRequests/getAgencyUsers';
import i18next from 'i18next';

const AgencyList = ({ page, changePage }: { page: string; changePage: (page: string) => void }) => {
  const { data, refetch, isLoading, isFetching } = useAgencyUsers({ page });
  const navigate = useNavigate();

  useEffect(() => {
    refetch();
  }, [page, refetch]);

  return (
    <>
      {isLoading || isFetching ? (
        <TableLoader />
      ) : (
        <Table<Agency>
          page={parseInt(page)}
          changePage={changePage}
          total={data?.total ?? 0}
          data={data?.data ?? []}
          columns={[
            { title: 'Agency name', field: 'first_name' },
            { title: `${i18next.t('Email')}`, field: 'email' },
            { title: `${i18next.t('Phone')}`, field: 'phone_number' },
            {
              title: 'Action',
              field: 'status',
              Cell({ entry: { id } }) {
                return (
                  <>
                    <span
                      role="button"
                      tabIndex={-1}
                      onKeyDown={() => navigate(`/admin/agencyDetail/${id}`)}
                      onClick={() => navigate(`/admin/agencyDetail/${id}`)}
                      className="icon me-2"
                      title="View"
                    >
                      <i className="fa-regular fa-eye" />
                    </span>
                  </>
                );
              },
            },
          ]}
        />
      )}
    </>
  );
};

export default AgencyList;
