import React, { useEffect } from 'react';
import { Table } from '@/components/Elements';
import { InvestmentCompany } from '@/types';
import TableLoader from '@/components/Elements/Loader/TableLoader';
import { useCompanyInvestmentList } from '@/features/admin/api/CompanyInvestmentList';
import { useNavigate } from 'react-router-dom';

const CompanyInvest = ({
  page,
  changePage,
}: {
  page: string;
  changePage: (page: string) => void;
}) => {
  const { data, refetch, isLoading, isFetching } = useCompanyInvestmentList({ page });
  const navigate = useNavigate();

  useEffect(() => {
    refetch();
  }, [page, refetch]);

  return (
    <>
      {isLoading || isFetching ? (
        <TableLoader />
      ) : (
        <Table<InvestmentCompany>
          page={parseInt(page)}
          changePage={changePage}
          total={data?.total ?? 0}
          data={data?.data ?? []}
          columns={[
            { title: 'Company Name', field: 'company_name' },
            { title: 'Company Established', field: 'company_established' },
            { title: 'Shares For Sale', field: 'shares_for_sale' },
            { title: `${i18next.t('Email')}`, field: 'company_email' },
            {
              title: 'Action',
              field: 'status',
              Cell({ entry: { id } }) {
                return (
                  <>
                    <span
                      role="button"
                      tabIndex={-1}
                      onKeyDown={() => navigate(`/admin/company-Investment-detail/${id}`)}
                      onClick={() => navigate(`/admin/company-Investment-detail/${id}`)}
                      className="icon me-2"
                      title="View"
                    >
                      <i className="fa-regular fa-eye" />
                    </span>
                  </>
                );
              },
            },
          ]}
        />
      )}
    </>
  );
};

export default CompanyInvest;
