import React, { useEffect } from 'react';
import { Table } from '@/components/Elements';
import { Agency } from '@/types';
import TableLoader from '@/components/Elements/Loader/TableLoader';
import { useNavigate } from 'react-router-dom';
import { useAgencyUsers } from '@/api/agencyRequests/getAgencyUsers';
import { LawyerData, useLawyerList } from '../api/getLawyerList';
import i18next from 'i18next';

const LawyerListing = ({
  page,
  changePage,
}: {
  page: string;
  changePage: (page: string) => void;
}) => {
  const { data, refetch, isLoading, isFetching } = useLawyerList({ page });
  const navigate = useNavigate();

  useEffect(() => {
    refetch();
  }, [page, refetch]);

  return (
    <>
      {isLoading || isFetching ? (
        <TableLoader />
      ) : (
        <Table<LawyerData>
          page={parseInt(page)}
          changePage={changePage}
          total={data?.total ?? 1}
          data={data?.data ?? []}
          columns={[
            { title: 'Lawyer name', field: 'first_name' },
            { title: `${i18next.t('Email')}`, field: 'email' },
            { title: `${i18next.t('Phone')}`, field: 'phone_number' },
            {
              title: 'Action',
              field: 'id',
              Cell({ entry: { id } }) {
                return (
                  <>
                    <span
                      role="button"
                      tabIndex={-1}
                      onKeyDown={() => navigate(`/admin/lawyerDetail/${id}`)}
                      onClick={() => navigate(`/admin/lawyerDetail/${id}`)}
                      className="icon me-2"
                      title="View"
                    >
                      <i className="fa-regular fa-eye" />
                    </span>
                  </>
                );
              },
            },
          ]}
        />
      )}
    </>
  );
};

export default LawyerListing;
