import React, { useEffect } from 'react';
import { Table } from '@/components/Elements';
import { Investment } from '@/types';
import TableLoader from '@/components/Elements/Loader/TableLoader';
import { useNavigate } from 'react-router-dom';
import { usePropertyInvestment } from '@/features/admin/api/getPropertyInvestment';
import { startCase } from 'lodash';

const ProjectInvestmentList = ({
  page,
  changePage,
}: {
  page: string;
  changePage: (page: string) => void;
}) => {
  const { data, refetch, isLoading, isFetching } = usePropertyInvestment({ page });
  const navigate = useNavigate();

  useEffect(() => {
    refetch();
  }, [page, refetch]);

  return (
    <>
      {isLoading || isFetching ? (
        <TableLoader />
      ) : (
        <Table<Investment>
          page={parseInt(page)}
          changePage={changePage}
          total={data?.total ?? 0}
          data={data?.data ?? []}
          columns={[
            {
              title: 'Customer Name',
              field: 'fullname',
              Cell({ entry: { fullname } }) {
                return <span>{startCase(fullname)}</span>;
              },
            },
            { title: 'Project Name', field: 'project_name' },
            { title: `${i18next.t('Location')}`, field: 'location' },
            {
              title: 'Action',
              field: 'status',
              Cell({ entry: { id } }) {
                return (
                  <>
                    <span
                      role="button"
                      tabIndex={-1}
                      onKeyDown={() => navigate(`/admin/project-investment-detail/${id}`)}
                      onClick={() => navigate(`/admin/project-investment-detail/${id}`)}
                      className="icon me-2"
                      title="View"
                    >
                      <i className="fa-regular fa-eye" />
                    </span>
                  </>
                );
              },
            },
          ]}
        />
      )}
    </>
  );
};

export default ProjectInvestmentList;
