import React, { useEffect, useState } from 'react';
import { Button, Table } from '@/components/Elements';
import { PropertyProject } from '@/types';
import TableLoader from '@/components/Elements/Loader/TableLoader';
import { ConfirmDialogWithButton } from '@/components/Elements/ConfirmationDialog/ConfirmDialogWithButton';
import { changeStatus } from '@/api/propertyProject/changeStatus';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate } from 'react-router-dom';
import { usePropertyProject } from '@/api/propertyProject/getPropertyProject';
import i18next from 'i18next';

const PropertyProjectList = ({
  page,
  changePage,
}: {
  page: string;
  changePage: (page: string) => void;
}) => {
  const { data, refetch, isLoading, isFetching } = usePropertyProject({ page });
  // const [loading, setLoading] = useState(false);
  const navigate = useNavigate();

  useEffect(() => {
    refetch();
  }, [page, refetch]);

  // const changeStatusAction = async (id: string, accept: boolean) => {
  //   try {
  //     setLoading(true);
  //     await changeStatus(id, accept);
  //     useNotificationStore.getState().addNotification({
  //       title: 'Success',
  //       type: 'success',
  //       message: 'You have approved this listing successfully!',
  //     });
  //     refetch();
  //   } finally {
  //     setLoading(false);
  //   }
  // };

  return (
    <>
      {isLoading || isFetching ? (
        <TableLoader />
      ) : (
        <Table<PropertyProject>
          page={parseInt(page)}
          changePage={changePage}
          total={data?.total ?? 0}
          data={data?.data ?? []}
          columns={[
            { title: `${i18next.t('Property Name')}`, field: 'property_name' },
            { title: 'Listed By', field: 'fullname' },
            { title: `${i18next.t('Price')}`, field: 'price' },
            // { title: 'Status', field: 'status' },
            // {
            //   title: '',
            //   field: 'status',
            //   Cell({ entry: { status, id } }) {
            //     return (
            //       <>
            //         {status === 'Pending' && (
            //           <ConfirmDialogWithButton
            //             triggerButton={<Button variant="outlineDark">Approve</Button>}
            //             confirmButton={
            //               <Button
            //                 isLoading={loading}
            //                 onClick={() => changeStatusAction(id, true)}
            //                 variant="primary"
            //               >
            //                 Approve
            //               </Button>
            //             }
            //             title="Confirm"
            //             icon="info"
            //             body="Are you sure you want to approve this property?"
            //           />
            //         )}
            //       </>
            //     );
            //   },
            // },
            {
              title: 'Action',
              field: 'status',
              Cell({ entry: { id } }) {
                return (
                  <>
                    <span
                      role="button"
                      tabIndex={-1}
                      onKeyDown={() => navigate(`/admin/property-project/${id}`)}
                      onClick={() => navigate(`/admin/property-project/${id}`)}
                      className="icon me-2"
                      title="View"
                    >
                      <i className="fa-regular fa-eye" />
                    </span>
                  </>
                );
              },
            },
          ]}
        />
      )}
    </>
  );
};

export default PropertyProjectList;
