import React, { useEffect } from 'react';
import { useUsers } from '@/api/users/getUsers';
import { Button, Table } from '@/components/Elements';
import { User } from '@/types';
import TableLoader from '@/components/Elements/Loader/TableLoader';
import { useNavigate } from 'react-router-dom';
import { ConfirmDialogWithButton } from '@/components/Elements/ConfirmationDialog/ConfirmDialogWithButton';
import './adminSidebar.css';
import i18next from 'i18next';

const SubscriptionList = ({
  page,
  changePage,
}: {
  page: string;
  changePage: (page: string) => void;
}) => {
  const { data, refetch, isLoading, isFetching } = useUsers({ page });
  const navigate = useNavigate();

  useEffect(() => {
    refetch();
  }, [page, refetch]);

  return (
    <>
      {isLoading || isFetching ? (
        <TableLoader />
      ) : (
        <>
          <div className="add-btn-sub">
            <Button
              onClick={() => {
                navigate('/admin/add-subscription');
              }}
            >
              + Add
            </Button>
          </div>
          <Table<User>
            page={parseInt(page)}
            changePage={changePage}
            total={data?.total ?? 0}
            data={data?.data ?? []}
            columns={[
              { title: `${i18next.t('Name')}`, field: 'first_name' },
              { title: `${i18next.t('Description')}`, field: 'email' },
              { title: `${i18next.t('Price')}`, field: 'phone_number' },
              {
                title: 'Ststus',
                field: 'status',
                Cell({ entry: { status, id } }) {
                  return (
                    <>
                      {/* {status === 'Pending' && ( */}
                      <ConfirmDialogWithButton
                        triggerButton={<Button variant="outlineDark">Approve</Button>}
                        confirmButton={
                          <Button
                            // isLoading={loading}
                            // onClick={() => changeStatusAction(id, true)}
                            variant="primary"
                          >
                            Approve
                          </Button>
                        }
                        title="Confirm"
                        icon="info"
                        body="Are you sure you want to approve this house request?"
                      />
                      {/* )}   */}
                    </>
                  );
                },
              },
              {
                title: 'Action',
                field: 'status',
                Cell({ entry: { id } }) {
                  return (
                    <>
                      <div className="row">
                        <span
                          role="button"
                          tabIndex={-1}
                          onKeyDown={() => navigate(`/admin/users/${id}`)}
                          onClick={() => navigate(`/admin/users/${id}`)}
                          className="icon me-2 col-md-6"
                          title="View"
                        >
                          <i className="fa-regular fa-eye" />
                        </span>
                        <span
                          role="button"
                          tabIndex={-1}
                          onKeyDown={() => navigate(`/admin/edit-subscription/${id}`)}
                          onClick={() => navigate(`/admin/edit-subscription/${id}`)}
                          className="icon me-2 col-md-6"
                          title="View"
                        >
                          <i className="fa-solid fa-pencil"></i>
                        </span>
                      </div>
                    </>
                  );
                },
              },
            ]}
          />
        </>
      )}
    </>
  );
};

export default SubscriptionList;
