import React, { useEffect, useState } from 'react';
import { AdminLayout } from '@/components/Layout';
import 'react-circular-progressbar/dist/styles.css';
import './Dashboard.css';
import building1 from '@/assets/building1.png';
import building2 from '@/assets/building2.png';
import building3 from '@/assets/building3.png';
import building4 from '@/assets/building4.png';

import { useNavigate } from 'react-router-dom';
import BarChart from '../components/BarChart';
import storage from '@/utils/storage';
import DashboardLoader from '@/components/Elements/Loader/DashboardLoader';
import i18next from 'i18next';

export const AdminReport = () => {
  const navigate = useNavigate();
  const axiosUrl = process.env.REACT_APP_API_URL;
  const [user, setUser] = useState([]);

  const token = storage.getToken();

  const fetchData = () => {
    const headers = { Authorization: `${token}` };
    return fetch(`${axiosUrl}/admin-api/reports`, { headers })
      .then((response) => response.json())
      .then((data) => setUser(data));
  };

  useEffect(() => {
    fetchData();
  }, []);

  return (
    <>
      {user?.count_data ? (
        <AdminLayout title="Admin Reports">
          <section className="dashboard-home">
            <div className="row">
              <button
                onClick={() => navigate('/property-for-sale')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.sale_property_count}</h4>
                      <h6>Properties For Sale</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building1} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                onClick={() => navigate('/property-for-rent')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.rent_property_count}</h4>

                      <h6>Properties For Rent</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building2} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                onClick={() => navigate('/housing-for-rent')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.house_wanted_rent_count}</h4>

                      <h6>House Wanted Rent</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building4} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                // onClick={() => navigate('/property-Sale-Rent')}
                onClick={() => null}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.customer_count}</h4>
                      <h6>Total Customer</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building3} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
            </div>
            <div className="row">
              <button
                onClick={() => navigate('/property-project')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.property_project_count}</h4>
                      <h6>{i18next.t('Property Project')}</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building3} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                onClick={() => navigate('/property-Sale-Rent')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.investment_my_company_count}</h4>
                      <h6>Investment My Company</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building3} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                onClick={() => navigate('business-for-sale')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.bussiness_for_sale_count}</h4>
                      <h6>Bussiness For Sale</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building2} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              {/* <button
                onClick={() => null}
                // onClick={() => navigate('/housing-for-rent')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.house_wanted_rent_count}</h4>
                      <h6>Property</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building1} alt="pics" />
                    </div>
                  </div>
                </div>
              </button> */}
            </div>

            <div className="row dbs">
              <div className="col-md-6 col-6 outerr">
                <div className="lefts">
                  <div className="row">
                    <div className="top-lefts">Active Customer</div>
                  </div>
                  <div className="chartH">
                    {user?.month_by_data && (
                      <BarChart
                        category={[
                          'Jan',
                          'Feb',
                          'March',
                          'April',
                          'May',
                          'June',
                          'July',
                          'Aug',
                          'Sept',
                          'Oct',
                          'Nov',
                          'Dec',
                        ]}
                        datas={[
                          `${user?.month_by_data?.active_customers[0]}`,
                          `${user?.month_by_data?.active_customers[1]}`,
                          `${user?.month_by_data?.active_customers[2]}`,
                          `${user?.month_by_data?.active_customers[3]}`,
                          `${user?.month_by_data?.active_customers[4]}`,
                          `${user?.month_by_data?.active_customers[5]}`,
                          `${user?.month_by_data?.active_customers[6]}`,
                          `${user?.month_by_data?.active_customers[7]}`,
                          `${user?.month_by_data?.active_customers[8]}`,
                          `${user?.month_by_data?.active_customers[9]}`,
                          `${user?.month_by_data?.active_customers[10]}`,
                          `${user?.month_by_data?.active_customers[11]}`,
                        ]}
                        name="Active Customer"
                      />
                    )}
                  </div>
                </div>
              </div>
              <div className="col-md-6 col-6 outerr">
                <div className="lefts">
                  <div className="row">
                    <div className="top-lefts">Business for Sale</div>
                  </div>
                  <div className="chartH">
                    {user?.month_by_data && (
                      <BarChart
                        category={[
                          'Jan',
                          'Feb',
                          'March',
                          'April',
                          'May',
                          'June',
                          'July',
                          'Aug',
                          'Sept',
                          'Oct',
                          'Nov',
                          'Dec',
                        ]}
                        datas={[
                          `${user?.month_by_data?.bussiness_for_sale[0]}`,
                          `${user?.month_by_data?.bussiness_for_sale[1]}`,
                          `${user?.month_by_data?.bussiness_for_sale[2]}`,
                          `${user?.month_by_data?.bussiness_for_sale[3]}`,
                          `${user?.month_by_data?.bussiness_for_sale[4]}`,
                          `${user?.month_by_data?.bussiness_for_sale[5]}`,
                          `${user?.month_by_data?.bussiness_for_sale[6]}`,
                          `${user?.month_by_data?.bussiness_for_sale[7]}`,
                          `${user?.month_by_data?.bussiness_for_sale[8]}`,
                          `${user?.month_by_data?.bussiness_for_sale[9]}`,
                          `${user?.month_by_data?.bussiness_for_sale[10]}`,
                          `${user?.month_by_data?.bussiness_for_sale[11]}`,
                        ]}
                        name="Business For Sale"
                      />
                    )}
                  </div>
                </div>
              </div>
            </div>
            <div className="row dbs">
              <div className="col-md-6 col-6 outerr">
                <div className="lefts">
                  <div className="row">
                    <div className="top-lefts">House Wanted for Rent</div>
                  </div>
                  <div className="chartH">
                    {user?.month_by_data && (
                      <BarChart
                        category={[
                          'Jan',
                          'Feb',
                          'March',
                          'April',
                          'May',
                          'June',
                          'July',
                          'Aug',
                          'Sept',
                          'Oct',
                          'Nov',
                          'Dec',
                        ]}
                        datas={[
                          `${user?.month_by_data?.house_wanted_rent[0]}`,
                          `${user?.month_by_data?.house_wanted_rent[1]}`,
                          `${user?.month_by_data?.house_wanted_rent[2]}`,
                          `${user?.month_by_data?.house_wanted_rent[3]}`,
                          `${user?.month_by_data?.house_wanted_rent[4]}`,
                          `${user?.month_by_data?.house_wanted_rent[5]}`,
                          `${user?.month_by_data?.house_wanted_rent[6]}`,
                          `${user?.month_by_data?.house_wanted_rent[7]}`,
                          `${user?.month_by_data?.house_wanted_rent[8]}`,
                          `${user?.month_by_data?.house_wanted_rent[9]}`,
                          `${user?.month_by_data?.house_wanted_rent[10]}`,
                          `${user?.month_by_data?.house_wanted_rent[11]}`,
                        ]}
                        name="Rent"
                      />
                    )}
                  </div>
                </div>
              </div>
              <div className="col-md-6 col-6 outerr">
                <div className="lefts">
                  <div className="row">
                    <div className="top-lefts">Inactive Customer</div>
                  </div>
                  <div className="chartH">
                    {user?.month_by_data && (
                      <BarChart
                        category={[
                          'Jan',
                          'Feb',
                          'March',
                          'April',
                          'May',
                          'June',
                          'July',
                          'Aug',
                          'Sept',
                          'Oct',
                          'Nov',
                          'Dec',
                        ]}
                        datas={[
                          `${user?.month_by_data?.inactive_customers[0]}`,
                          `${user?.month_by_data?.inactive_customers[1]}`,
                          `${user?.month_by_data?.inactive_customers[2]}`,
                          `${user?.month_by_data?.inactive_customers[3]}`,
                          `${user?.month_by_data?.inactive_customers[4]}`,
                          `${user?.month_by_data?.inactive_customers[5]}`,
                          `${user?.month_by_data?.inactive_customers[6]}`,
                          `${user?.month_by_data?.inactive_customers[7]}`,
                          `${user?.month_by_data?.inactive_customers[8]}`,
                          `${user?.month_by_data?.inactive_customers[9]}`,
                          `${user?.month_by_data?.inactive_customers[10]}`,
                          `${user?.month_by_data?.inactive_customers[11]}`,
                        ]}
                        name="Inactive"
                      />
                    )}
                  </div>
                </div>
              </div>
            </div>

            <div className="row dbs">
              <div className="col-md-6 col-6 outerr">
                <div className="lefts">
                  <div className="row">
                    <div className="top-lefts">Investment in company</div>
                  </div>
                  <div className="chartH">
                    {user?.month_by_data && (
                      <BarChart
                        category={[
                          'Jan',
                          'Feb',
                          'March',
                          'April',
                          'May',
                          'June',
                          'July',
                          'Aug',
                          'Sept',
                          'Oct',
                          'Nov',
                          'Dec',
                        ]}
                        datas={[
                          `${user?.month_by_data?.investment_my_company[0]}`,
                          `${user?.month_by_data?.investment_my_company[1]}`,
                          `${user?.month_by_data?.investment_my_company[2]}`,
                          `${user?.month_by_data?.investment_my_company[3]}`,
                          `${user?.month_by_data?.investment_my_company[4]}`,
                          `${user?.month_by_data?.investment_my_company[5]}`,
                          `${user?.month_by_data?.investment_my_company[6]}`,
                          `${user?.month_by_data?.investment_my_company[7]}`,
                          `${user?.month_by_data?.investment_my_company[8]}`,
                          `${user?.month_by_data?.investment_my_company[9]}`,
                          `${user?.month_by_data?.investment_my_company[10]}`,
                          `${user?.month_by_data?.investment_my_company[11]}`,
                        ]}
                        name="Investment in Company"
                      />
                    )}
                  </div>
                </div>
              </div>
              <div className="col-md-6 col-6 outerr">
                <div className="lefts">
                  <div className="row">
                    <div className="top-lefts">Investment in my Project</div>
                  </div>
                  <div className="chartH">
                    {user?.month_by_data && (
                      <BarChart
                        category={[
                          'Jan',
                          'Feb',
                          'March',
                          'April',
                          'May',
                          'June',
                          'July',
                          'Aug',
                          'Sept',
                          'Oct',
                          'Nov',
                          'Dec',
                        ]}
                        datas={[
                          `${user?.month_by_data?.investment_my_project[0]}`,
                          `${user?.month_by_data?.investment_my_project[1]}`,
                          `${user?.month_by_data?.investment_my_project[2]}`,
                          `${user?.month_by_data?.investment_my_project[3]}`,
                          `${user?.month_by_data?.investment_my_project[4]}`,
                          `${user?.month_by_data?.investment_my_project[5]}`,
                          `${user?.month_by_data?.investment_my_project[6]}`,
                          `${user?.month_by_data?.investment_my_project[7]}`,
                          `${user?.month_by_data?.investment_my_project[8]}`,
                          `${user?.month_by_data?.investment_my_project[9]}`,
                          `${user?.month_by_data?.investment_my_project[10]}`,
                          `${user?.month_by_data?.investment_my_project[11]}`,
                        ]}
                        name="Investment in my Project"
                      />
                    )}
                  </div>
                </div>
              </div>
            </div>

            <div className="row dbs">
              <div className="col-md-6 col-6 outerr">
                <div className="lefts">
                  <div className="row">
                    <div className="top-lefts">{i18next.t('Property Project')}</div>
                  </div>
                  <div className="chartH">
                    {user?.month_by_data && (
                      <BarChart
                        category={[
                          'Jan',
                          'Feb',
                          'March',
                          'April',
                          'May',
                          'June',
                          'July',
                          'Aug',
                          'Sept',
                          'Oct',
                          'Nov',
                          'Dec',
                        ]}
                        datas={[
                          `${user?.month_by_data?.property_project[0]}`,
                          `${user?.month_by_data?.property_project[1]}`,
                          `${user?.month_by_data?.property_project[2]}`,
                          `${user?.month_by_data?.property_project[3]}`,
                          `${user?.month_by_data?.property_project[4]}`,
                          `${user?.month_by_data?.property_project[5]}`,
                          `${user?.month_by_data?.property_project[6]}`,
                          `${user?.month_by_data?.property_project[7]}`,
                          `${user?.month_by_data?.property_project[8]}`,
                          `${user?.month_by_data?.property_project[9]}`,
                          `${user?.month_by_data?.property_project[10]}`,
                          `${user?.month_by_data?.property_project[11]}`,
                        ]}
                        name="Property Project"
                      />
                    )}
                  </div>
                </div>
              </div>
              <div className="col-md-6 col-6 outerr">
                <div className="lefts">
                  <div className="row">
                    <div className="top-lefts"> {i18next.t('Property for rent')}</div>
                  </div>
                  <div className="chartH">
                    {user?.month_by_data && (
                      <BarChart
                        category={[
                          'Jan',
                          'Feb',
                          'March',
                          'April',
                          'May',
                          'June',
                          'July',
                          'Aug',
                          'Sept',
                          'Oct',
                          'Nov',
                          'Dec',
                        ]}
                        datas={[
                          `${user?.month_by_data?.rent_property[0]}`,
                          `${user?.month_by_data?.rent_property[1]}`,
                          `${user?.month_by_data?.rent_property[2]}`,
                          `${user?.month_by_data?.rent_property[3]}`,
                          `${user?.month_by_data?.rent_property[4]}`,
                          `${user?.month_by_data?.rent_property[5]}`,
                          `${user?.month_by_data?.rent_property[6]}`,
                          `${user?.month_by_data?.rent_property[7]}`,
                          `${user?.month_by_data?.rent_property[8]}`,
                          `${user?.month_by_data?.rent_property[9]}`,
                          `${user?.month_by_data?.rent_property[10]}`,
                          `${user?.month_by_data?.rent_property[11]}`,
                        ]}
                        name="Property for rent"
                      />
                    )}
                  </div>
                </div>
              </div>
            </div>

            <div className="row dbs">
              <div className="col-md-6 col-6 outerr">
                <div className="lefts">
                  <div className="row">
                    <div className="top-lefts">{i18next.t('Property for Sale')}</div>
                  </div>
                  <div className="chartH">
                    {user?.month_by_data && (
                      <BarChart
                        category={[
                          'Jan',
                          'Feb',
                          'March',
                          'April',
                          'May',
                          'June',
                          'July',
                          'Aug',
                          'Sept',
                          'Oct',
                          'Nov',
                          'Dec',
                        ]}
                        datas={[
                          `${user?.month_by_data?.sale_property[0]}`,
                          `${user?.month_by_data?.sale_property[1]}`,
                          `${user?.month_by_data?.sale_property[2]}`,
                          `${user?.month_by_data?.sale_property[3]}`,
                          `${user?.month_by_data?.sale_property[4]}`,
                          `${user?.month_by_data?.sale_property[5]}`,
                          `${user?.month_by_data?.sale_property[6]}`,
                          `${user?.month_by_data?.sale_property[7]}`,
                          `${user?.month_by_data?.sale_property[8]}`,
                          `${user?.month_by_data?.sale_property[9]}`,
                          `${user?.month_by_data?.sale_property[10]}`,
                          `${user?.month_by_data?.sale_property[11]}`,
                        ]}
                        name={i18next.t('Property for Sale')}
                      />
                    )}
                  </div>
                </div>
              </div>
              <div className="col-md-6 col-6 outerr">
                <div className="lefts">
                  <div className="row">
                    <div className="top-lefts">Total Customer</div>
                  </div>
                  <div className="chartH">
                    {user?.month_by_data && (
                      <BarChart
                        category={[
                          'Jan',
                          'Feb',
                          'March',
                          'April',
                          'May',
                          'June',
                          'July',
                          'Aug',
                          'Sept',
                          'Oct',
                          'Nov',
                          'Dec',
                        ]}
                        datas={[
                          `${user?.month_by_data?.total_customers[0]}`,
                          `${user?.month_by_data?.total_customers[1]}`,
                          `${user?.month_by_data?.total_customers[2]}`,
                          `${user?.month_by_data?.total_customers[3]}`,
                          `${user?.month_by_data?.total_customers[4]}`,
                          `${user?.month_by_data?.total_customers[5]}`,
                          `${user?.month_by_data?.total_customers[6]}`,
                          `${user?.month_by_data?.total_customers[7]}`,
                          `${user?.month_by_data?.total_customers[8]}`,
                          `${user?.month_by_data?.total_customers[9]}`,
                          `${user?.month_by_data?.total_customers[10]}`,
                          `${user?.month_by_data?.total_customers[11]}`,
                        ]}
                        name="Total Customer"
                      />
                    )}
                  </div>
                </div>
              </div>
            </div>
            {/* 
        <div className="row dbs">
          <div className="col-md-8 col-8 outerr">
            <div className="lefts">
              <div className="row">
                <div className="col-md-6 col-6 top-lefts">Active Customers</div>
                <div className="col-md-6 col-6 trights">
                  <button
                    className={clsx('btext', togl == 1 ? 'activeTogl' : '')}
                    onClick={() => setTogl(1)}
                  >
                    Monthly
                  </button>
                  <button
                    className={clsx('btext', togl == 2 ? 'activeTogl' : '')}
                    onClick={() => setTogl(2)}
                  >
                    Yearly
                  </button>
                </div>
              </div>
              <div className="row">
                <div className="col-md-6 col-6 btms-lefts">
                  <span className="dlrs">$678,987</span>Last year $689,888
                </div>
                <div className="col-md-6 col-6 trights">7%</div>
              </div>
              {togl == 1 ? (
                <div className="chartH">
                  <VictoryChart domainPadding={20}>
                    <VictoryBar
                      data={dataActive_customers}
                      x="quarter"
                      y="earnings"
                      style={{
                        data: { fill: 'YellowGreen' },
                      }}
                    />
                  </VictoryChart>
                </div>
              ) : (
                <div className="chartH">
                  <VictoryChart domainPadding={20}>
                    <VictoryBar
                      data={dataYear}
                      x="quarter"
                      y="earnings"
                      style={{
                        data: { fill: 'Yellow' },
                      }}
                    />
                  </VictoryChart>
                </div>
              )}
            </div>
          </div>
          <div className="outerr col-md-4 col-4">
            <div className=" rights">
              <div>
                <h4>Total Properties</h4>
                <VictoryPie innerRadius={90} data={dataPIe} theme={VictoryTheme.material} />
                <div className="row">
                  <div className="col-md-6 col-6">
                    <i className="fa-solid fa-circle-dot"></i> Commercial
                  </div>
                  <div className="col-md-6 col-6">
                    <i className="fa-solid fa-circle-dot"></i> Residential
                  </div>
                  <div className="col-md-6 col-6">
                    <i className="fa-solid fa-circle-dot"></i> Purchased
                  </div>
                  <div className="col-md-6 col-6">
                    <i className="fa-solid fa-circle-dot"></i> Rent
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div> */}
            {/* <div className="table-box">
          <div className="box-in">
            <div className="row">
              <div className="col-6 col-md-6">User Management</div>
              <div className="col-6 col-md-6 left">
                View All <button className="cross">X</button>
              </div>
            </div>
            <div>
              <Table<User>
                page={10}
                changePage={() => null}
                total={10}
                data={[]}
                columns={[
                  { title: 'Company Name', field: 'id' },
                  { title: 'Company Telephone', field: 'name' },
                  { title: 'Category', field: 'title' },
                  { title: 'Purchase Price', field: 'role' },
                  { title: 'Total Turnover', field: 'email' },
                ]}
              />
            </div>
          </div>
        </div> */}
          </section>
        </AdminLayout>
      ) : (
        <div className="row spins">
          <DashboardLoader />
        </div>
      )}
    </>
  );
};
