import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import { Entry } from '@/components/Elements/Table/Entry';
import UserDetailLoader from '@/components/Elements/Loader/UserDetailLoader';
import { useAgencyDetail } from '@/api/agencyRequests/getAgencyDetail';
import i18next from 'i18next';

export const AgencyMemberDetail = () => {
  const { id } = useParams();
  const { data, isLoading, isFetching } = useAgencyDetail({ id: id ?? '1' });
  const user = data?.data;

  return (
    <AdminLayout title="Agency Details">
      {isLoading || isFetching ? (
        <UserDetailLoader />
      ) : (
        <div className="row mt-2">
          <div className="col-12">
            <FileViewer file={user?.profile_image}></FileViewer>
          </div>
          <div className="col-12 my-4">
            <Entry label="Customer Name" value={`${user?.first_name} ${user?.last_name}`} />
            <Entry label={i18next.t('Email')} value={user?.email === '' ? 'N/A' : user?.email} />
            {user?.dob !== '' && (
              <Entry label="Date of birth" value={user?.dob === '' ? 'N/A' : user?.dob} />
            )}
            {user?.gender !== '' && (
              <Entry label="Gender" value={user?.gender === '' ? 'N/A' : user?.gender} />
            )}
            <Entry label="Address" value={user?.address === '' ? 'N/A' : user?.address} />
            {user?.nationality !== '' && (
              <Entry
                label={i18next.t('Country')}
                value={user?.nationality === '' ? 'N/A' : user?.nationality}
              />
            )}
            {user?.bio !== '' && <Entry label="Bio" value={user?.bio === '' ? 'N/A' : user?.bio} />}
            {user?.past_experience !== '' && (
              <Entry
                label="Experience"
                value={user?.past_experience === '' ? 'N/A' : user?.past_experience}
              />
            )}
          </div>
        </div>
      )}
    </AdminLayout>
  );
};
