import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { useBusinessDetails } from '@/api/business/getBusinessDetail';
import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import { Entry } from '@/components/Elements/Table/Entry';
import BusinessDetailLoader from '@/components/Elements/Loader/BusinessDetailLoader';
import companyCategory from '@/constants/companyCategory';
import i18next from 'i18next';

export const Business = () => {
  const { id } = useParams();
  const { data, isLoading, isFetching } = useBusinessDetails({ id: id ?? '1' });
  const business = data?.data;

  return (
    <AdminLayout title="Business Details">
      {isLoading || isFetching ? (
        <BusinessDetailLoader />
      ) : (
        <div className="row mt-2">
          <div className="col-12">
            {business?.videos ? (
              <>
                <h4 className="mb-4">Video</h4>
                <FileViewer file={business?.videos ?? ''}></FileViewer>
              </>
            ) : null}
          </div>
          <div className="col-12 mt-3">
            <h4 className="mb-4">Image</h4>
            <div className="row">
              {eval(business?.image_data).map((item: any, index: number) => (
                <div className="imB" key={index}>
                  <div className="image-box-n">
                    <FileViewer file={item?.image ?? ''}></FileViewer>
                  </div>
                  {item?.name && <p className="nameImage">{business?.image_data?.name ?? ''}</p>}
                </div>
              ))}
            </div>
          </div>

          <div className="col-12 mt-4">
            <Entry label="Customer Name" value={business?.customer_name ?? ''} />
            <Entry label={i18next.t('Company Name')} value={business?.company_name ?? ''} />
            <Entry label="Company Established (Year)" value={business?.company_established ?? ''} />
            <Entry label="Number of employees" value={business?.number_of_employes ?? ''} />
            <Entry label="Company Email" value={business?.company_email ?? ''} />
            <Entry label="Company Telephone" value={business?.company_telephone ?? ''} />
            <Entry
              label="Company Category"
              value={companyCategory[business?.company_category] ?? ''}
            />
            <Entry label="Opening Hours" value={business?.opening_hours ?? ''} />
            <Entry label={i18next.t('Purchase price')} value={business?.purchase_price ?? ''} />
            <Entry label="Total Turnover" value={business?.total_turnover ?? ''} />
            <Entry label="Operating Profit" value={business?.operating_profit ?? ''} />
            <Entry
              label={i18next.t('Salary Percentage')}
              value={business?.salary_percentage ?? ''}
            />
            <Entry label={i18next.t('Company Details')} value={business?.company_details ?? ''} />
            <Entry label="Company Vision" value={business?.company_vision ?? ''} />
            <Entry label={i18next.t('Note to purchase')} value={business?.note_to_purchase ?? ''} />
            <Entry label="Facebook" value={business?.company_facebook_link ?? ''} />
            <Entry label="Twitter" value={business?.company_twitter_link ?? ''} />
            <Entry label={i18next.t('Youtube')} value={business?.company_youtube_link ?? ''} />
            <Entry label="Linkedin" value={business?.company_linkedin_link ?? ''} />
          </div>
        </div>
      )}
    </AdminLayout>
  );
};
