import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { useCompanyInvestmentDetail } from '@/features/admin/api/getCompanyInvestmentDetail';
import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import { Entry } from '@/components/Elements/Table/Entry';
import BusinessDetailLoader from '@/components/Elements/Loader/BusinessDetailLoader';
import i18next from 'i18next';

export const CompanyInvestmentDetail = () => {
  const { id } = useParams();
  const { data, isLoading, isFetching } = useCompanyInvestmentDetail({ id: id ?? '1' });
  const business = data?.data;

  return (
    <AdminLayout title="Company Investment Detail">
      {isLoading || isFetching ? (
        <BusinessDetailLoader />
      ) : (
        <div className="row mt-2">
          <div className="col-12">
            <h4 className="mb-4">Video</h4>
            <FileViewer file={business?.video ?? ''}></FileViewer>
          </div>
          <div className="col-12 mt-3">
            <h4 className="mb-4">Image</h4>
            <div className="row">
              {business?.image_data ? (
                <>
                  {eval(business?.image_data).map((item: any, index: number) => (
                    <div className="imB" key={index}>
                      <div className="image-box-n">
                        <FileViewer file={item?.image ?? ''}></FileViewer>
                      </div>
                      {item?.name && <p className="nameImage">{item?.name ?? ''}</p>}
                    </div>
                  ))}
                </>
              ) : (
                <p>NO image found</p>
              )}
            </div>
          </div>

          <div className="col-12 mt-3">
            <h4 className="mb-4">Teams</h4>
            <div className="row">
              {business?.team ? (
                <>
                  {eval(business?.team).map((item: any, index: number) => (
                    <div className="imB" key={index}>
                      <div className="image-box-n">
                        <FileViewer file={item?.image ?? ''}></FileViewer>
                      </div>
                      {item?.name && <p className="nameImage">{item?.name ?? ''}</p>}
                      {item?.about && <p className="nameImage">{item?.about ?? ''}</p>}
                    </div>
                  ))}
                </>
              ) : (
                <p>NO image found</p>
              )}
            </div>
          </div>

          <div className="col-12 mt-3">
            <h4 className="mb-4">Partners</h4>
            <div className="row">
              {business?.partners ? (
                <>
                  {eval(business?.partners).map((item: any, index: number) => (
                    <div className="imB" key={index}>
                      <div className="image-box-n">
                        <FileViewer file={item?.image ?? ''}></FileViewer>
                      </div>
                      {item?.name && <p className="nameImage">{item?.name ?? ''}</p>}
                      {item?.about && <p className="nameImage">{item?.about ?? ''}</p>}
                    </div>
                  ))}
                </>
              ) : (
                <p>NO image found</p>
              )}
            </div>
          </div>

          <div className="col-12 mt-3">
            <h4 className="mb-4">{i18next.t('Board Members')}</h4>
            <div className="row">
              {business?.board ? (
                <>
                  {eval(business?.board).map((item: any, index: number) => (
                    <div className="imB" key={index}>
                      <div className="image-box-n">
                        <FileViewer file={item?.image ?? ''}></FileViewer>
                      </div>
                      {item?.name && <p className="nameImage">{item?.name ?? ''}</p>}
                      {item?.about && <p className="nameImage">{item?.about ?? ''}</p>}
                    </div>
                  ))}
                </>
              ) : (
                <p>NO image found</p>
              )}
            </div>
          </div>
          <div className="col-12 mt-4">
            <Entry label={i18next.t('Name')} value={business?.company_name ?? ''} />
            <Entry label="Established (Year)" value={business?.company_established ?? ''} />
            <Entry label={i18next.t('Email')} value={business?.company_email ?? ''} />
            <Entry label="Telephone" value={business?.company_telephone ?? ''} />
            <Entry label="Address" value={business?.company_address ?? ''} />
            <Entry label={i18next.t('Description')} value={business?.description ?? ''} />
            <Entry label="Doccument Data" value={business?.documents_data ?? ''} />
            <Entry label="Minimum Drawing" value={business?.minimum_drawing ?? ''} />
            <Entry label="Maximum Drawing" value={business?.max_drawing ?? ''} />
            <Entry label="Remaining Shares" value={business?.remaninig_shares ?? ''} />
            <Entry label="Shares For Sale" value={business?.shares_for_sale ?? ''} />
            <Entry label={i18next.t('Valuation')} value={business?.the_valuation ?? ''} />
            <Entry label={i18next.t('Youtube')} value={business?.youtube_url ?? ''} />
          </div>
        </div>
      )}
    </AdminLayout>
  );
};
