import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import { Entry } from '@/components/Elements/Table/Entry';
import HousingDetailLoader from '@/components/Elements/Loader/HousingDetailLoader';
import { useHousingDetails } from '@/api/housing/getHousingDetail';
import propertyType from '@/constants/propertyType';
import { formatDate } from '@/utils/format';
import storage from '@/utils/storage';
import i18next from 'i18next';

export const HousingDetail = () => {
  const { id } = useParams();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const { data, isLoading, isFetching } = useHousingDetails({ id: id ?? '1' });
  const item = data?.data;
  return (
    <AdminLayout title="Housing Request Details">
      {isLoading || isFetching ? (
        <HousingDetailLoader />
      ) : (
        <div className="row mt-2">
          <div className="col-5">
            <h4 className="mb-4">Image</h4>
            <FileViewer file={item?.image ?? ''}></FileViewer>
          </div>
          <div>
            {eval(item?.image_data).map((item: any, index: number) => (
              <div className="imB" key={index}>
                <div className="image-box-n">
                  <FileViewer file={item?.image ?? ''}></FileViewer>
                </div>
                {item?.name && <p className="nameImage">{item?.image_one_name ?? ''}</p>}
              </div>
            ))}
          </div>

          <div className="col-12 my-4">
            <Entry label="Customer Name" value={item?.fullname ?? ''} />
            <Entry label={i18next.t('Phone')} value={item?.phone_number ?? ''} />
            <Entry label="Gender" value={item?.gender ?? ''} />
            <Entry
              label={`Max Month Price ${localSymbol}`}
              value={item?.max_month_price ? item?.max_month_price * localCurrency : ''}
            />
            <Entry label="Property type" value={propertyType[item?.property_type ?? 'one_bhk']} />
            <Entry label="Wanting From" value={formatDate(item?.wanted_from ?? '')} />
            <Entry label="Number of residents" value={item?.no_of_resident ?? ''} />
            <Entry label={i18next.t('Location')} value={item?.location ?? ''} />
            <Entry label="Date of birth" value={formatDate(item?.dob ?? '')} />
            <Entry label="Address" value={item?.address ?? ''} />
            <Entry label={i18next.t('Description')} value={item?.about ?? ''} />
            <Entry label="Add Header" value={item?.ad_header ?? ''} />
            <Entry label={i18next.t('Country')} value={item?.country ?? ''} />
            <Entry label={i18next.t('Email')} value={item?.email ?? ''} />
            <Entry label={i18next.t('Wanted From')} value={item?.wanted_from ?? ''} />
            <Entry label="Furnishings" value={item?.furnishings ?? ''} />
            <Entry label={i18next.t('Pet')} value={item?.pet ?? ''} />
            <Entry label={i18next.t('Location')} value={item?.location ?? ''} />
          </div>
        </div>
      )}
    </AdminLayout>
  );
};
