import { AdminLayout } from '@/components/Layout';
import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import { Entry } from '@/components/Elements/Table/Entry';
import HousingDetailLoader from '@/components/Elements/Loader/HousingDetailLoader';
import { usePropertyInvestmentDetail } from '@/features/admin/api/getPropertyInvestmentDetail';
import storage from '@/utils/storage';
import i18next from 'i18next';

export const ProjectInvestmentDetail = () => {
  const { id } = useParams();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const { data, isLoading, isFetching } = usePropertyInvestmentDetail({ id: id ?? '1' });
  const item = data?.data;
  const overview = <div dangerouslySetInnerHTML={{ __html: item?.overview }} />;
  const financial_debt_assumption = (
    <div dangerouslySetInnerHTML={{ __html: item?.financial_debt_assumption }} />
  );
  const property_detail = <div dangerouslySetInnerHTML={{ __html: item?.property_detail }} />;
  const property_location = <div dangerouslySetInnerHTML={{ __html: item?.property_location }} />;
  const property_summary = <div dangerouslySetInnerHTML={{ __html: item?.property_summary }} />;

  return (
    <AdminLayout title="Project Investment Detail">
      {isLoading || isFetching ? (
        <HousingDetailLoader />
      ) : (
        <div className="row mt-2">
          <div className="col-md-4">
            {' '}
            <FileViewer file={item?.videos ?? ''}></FileViewer>
          </div>
          {item?.image_data ? (
            <>
              {eval(item?.image_data).map((item: any, index: number) => (
                <div className="imB" key={index}>
                  <div className="image-box-n">
                    <FileViewer file={item?.image ?? ''}></FileViewer>
                  </div>
                  {item?.name && <p className="nameImage">{item?.name ?? ''}</p>}
                </div>
              ))}
            </>
          ) : (
            <p>NO image found</p>
          )}

          <div className="row mt-4">
            <h5>Property At glance : </h5>
            {item?.property_at_glance ? (
              <>
                {eval(item?.property_at_glance).map((item: any, index: number) => (
                  <div className="imB" key={index}>
                    {item?.item && <p className="nameImage">{item?.item ?? ''}</p>}
                    {item?.data && <p className="nameImage">{item?.data ?? ''}</p>}
                  </div>
                ))}
              </>
            ) : (
              <p>NO property At Glance found</p>
            )}
          </div>
          <div className="row managementAbout">
            <div className="col-md-3">
              <FileViewer file={item?.management_logo}></FileViewer>
            </div>
            <div className="col-md-9">{item?.about_management}</div>
          </div>

          {item?.partner ? (
            <>
              {eval(item?.partner).map((item: any, index: number) => (
                <div className="imB mt-4" key={index}>
                  <div className="image-box-n">
                    <FileViewer file={item?.image ?? ''}></FileViewer>
                  </div>
                  {item?.name && <p className="nameImage">{item?.name ?? ''}</p>}
                  {item?.position && <p className="nameImage">{item?.position ?? ''}</p>}
                  {item?.about && <p className="nameImage">{item?.about ?? ''}</p>}
                  {item?.linkedin && <p className="nameImage">{item?.linkedin ?? ''}</p>}
                </div>
              ))}
            </>
          ) : (
            <p>NO image found</p>
          )}
          <div className="col-12 my-4">
            <Entry label={i18next.t('Title')} value={item?.project_name ?? ''} />
            <Entry label={i18next.t('Property Type')} value={item?.property_type ?? ''} />
            {item?.about && <Entry label="About" value={item?.about ?? ''} />}
            <Entry label={i18next.t('Asset Quality')} value={item?.asset_quality ?? ''} />
            <Entry label="Busines Plan" value={item?.business_plan ?? ''} />
            <Entry label={i18next.t('Disclaimer')} value={item?.disclaimers ?? ''} />
            <Entry label="Doccuments Data" value={item?.documents_data ?? ''} />
            <Entry
              label={`${i18next.t('Estimated First Distribution')} ${localSymbol}`}
              value={(item?.estimated_first_distribution * localCurrency)?.toFixed(0) ?? ''}
            />
            <Entry
              label={i18next.t('Estimated Hold Period')}
              value={item?.estimated_hold_period ?? ''}
            />
            <Entry label="Funded" value={item?.funded ?? ''} />
            <Entry
              label={i18next.t('Investment Highlights')}
              value={item?.investment_highlights ?? ''}
            />
            <Entry
              label={i18next.t('Investment Strategy')}
              value={item?.investment_strategy ?? ''}
            />
            <Entry label={i18next.t('Investment Type')} value={item?.investment_type ?? ''} />
            <Entry label={i18next.t('Location')} value={item?.location ?? ''} />
            <Entry
              label={`Minimum Investment ${localSymbol}`}
              value={(item?.minimum_investment * localCurrency)?.toFixed(0) ?? ''}
            />
            <Entry label="Offered By" value={item?.offered_by ?? ''} />
            <Entry label="Overview" value={overview ?? ''} />
            <Entry label={i18next.t('Phone')} value={item?.phone_number ?? ''} />
            <Entry
              label={`${i18next.t('Target Equity Multiple')} ${localSymbol}`}
              value={(item?.target_equity_multiple * localCurrency)?.toFixed(0) ?? ''}
            />
            <Entry
              label={`Target Irr ${localSymbol}`}
              value={(item?.target_irr * localCurrency)?.toFixed(0) ?? ''}
            />
            <Entry
              label={`Target Return On Cost ${localSymbol}`}
              value={(item?.target_return_on_cost * localCurrency)?.toFixed(0) ?? ''}
            />
            <Entry label={i18next.t('Property Summary')} value={property_summary ?? ''} />
            <Entry label={i18next.t('Property Location')} value={property_location ?? ''} />
            <Entry label={i18next.t('Property Detail')} value={property_detail ?? ''} />
            <Entry
              label={i18next.t('Financial Debt Assumption')}
              value={financial_debt_assumption ?? ''}
            />
          </div>
        </div>
      )}
    </AdminLayout>
  );
};
