import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import { Entry } from '@/components/Elements/Table/Entry';
import BusinessDetailLoader from '@/components/Elements/Loader/BusinessDetailLoader';
import { usePropertyDetails } from '@/api/property/getPropertyDetails';
import i18next from 'i18next';

export const Property = () => {
  const { id } = useParams();
  const { data, isLoading, isFetching } = usePropertyDetails({ id: id ?? '1' });
  const property = data?.data;

  return (
    <AdminLayout title="Property Details">
      {isLoading || isFetching ? (
        <BusinessDetailLoader />
      ) : (
        <div className="row mt-2">
          <div className="col-5">
            <h4 className="mb-4">Image</h4>
            <FileViewer file={property?.image ?? ''}></FileViewer>
          </div>
          <div className="col-5">
            <h4 className="mb-4">Video</h4>
            {property?.youtube_url.includes('https://www.youtube.com/watch?v=') && (
              <iframe
                title="ytvid"
                id="ytplayer"
                width="640"
                height="360"
                src={
                  property?.youtube_url?.replace(
                    'https://www.youtube.com/watch?v=',
                    'https://www.youtube.com/embed/'
                  ) ?? ''
                }
                frameBorder="0"
              ></iframe>
            )}
          </div>
          <div className="col-12 mt-4">
            <Entry label={i18next.t('Property Type')} value={property?.property_type ?? ''} />
            <Entry label={i18next.t('Title')} value={property?.title ?? ''} />
            <Entry label="Category" value={property?.category ?? ''} />
            <Entry label="Subcategory" value={property?.subcategory ?? ''} />
            <Entry label={i18next.t('Phone')} value={property?.phone_number ?? ''} />
            <Entry label={i18next.t('Description')} value={property?.description ?? ''} />
            <Entry label="Size" value={property?.size ?? ''} />
            <Entry label={i18next.t('Closing Fee')} value={property?.closingFee ?? ''} />
            <Entry label={i18next.t('Bedrooms')} value={property?.bedrooms ?? ''} />
            <Entry label="Bathrooms" value={property?.bathrooms ?? ''} />
            <Entry label="Developer" value={property?.developer ?? ''} />
            <Entry
              label={i18next.t('Annual community fee')}
              value={property?.annual_community_fee ?? ''}
            />
            <Entry label="Property Reference Id" value={property?.property_reference_id ?? ''} />
            <Entry label="Buyer Transfer Fee" value={property?.buyer_transfer_fee ?? ''} />
            <Entry label="Seller Transfer Fee" value={property?.seller_transfer_fee ?? ''} />
            <Entry label="Maintenance Fee" value={property?.maintenance_fee ?? ''} />
            <Entry label="Occupancy Status" value={property?.occupancy_status ?? ''} />
            <Entry label={i18next.t('Amenities')} value={property?.amenities ?? ''} />
            <Entry label="User is" value={property?.user_is ?? ''} />
            <Entry label={i18next.t('Building')} value={property?.building ?? ''} />
            <Entry label={i18next.t('Neighbourhood')} value={property?.neighbourhood ?? ''} />
            <Entry label="Latitude" value={property?.latitude ?? ''} />
            <Entry label="Longitude" value={property?.longitude ?? ''} />
          </div>
        </div>
      )}
    </AdminLayout>
  );
};
