import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { usePagination } from '@/hooks/usePagination';
import PropertyForRentList from '../../components/PropertyForRentList';
import i18next from 'i18next';

export const PropertyForRent = () => {
  const { page, changePage } = usePagination();

  return (
    <AdminLayout title={i18next.t('Property For Rent')}>
      <PropertyForRentList page={page} changePage={changePage} />
    </AdminLayout>
  );
};
