import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import { Entry } from '@/components/Elements/Table/Entry';
import { useRentDetails } from '@/features/admin/api/getPropertyForRentDetail';
import './saleproperty.css';
import propertyCategory from '@/constants/propertyCategory';
import amanetiesIcon from '@/constants/amanetiesCategory';
import subRentCategory from '@/constants/subRentCategory';
import mainRentCategory from '@/constants/mainRentCategory';
import AdminPp from '@/components/Elements/Loader/AdminPp';
import i18next from 'i18next';

export const PropertyForRentDetail = () => {
  const { id } = useParams();
  const { data, isLoading, isFetching } = useRentDetails({ id: id ?? '1' });
  const item = data?.data;

  const categoryVal = item?.category;
  let CategoryValue = '';
  {
    Object.entries(propertyCategory).map(([key, val], i) => (
      <p key={i}>{key == categoryVal ? (CategoryValue = val) : null}</p>
    ));
  }

  const amenitiessArray = item?.facilites.split(',');

  const translateAmenties = (val: any): string => {
    return i18next.t(val);
  };

  return (
    <AdminLayout title="Property For Rent Detail">
      {isLoading || isFetching ? (
        <AdminPp />
      ) : (
        <div className="row mt-2">
          {eval(item?.image_data).map((item: any, index: number) => (
            <div className="imB" key={index}>
              <div className="image-box-n">
                <FileViewer file={item?.image ?? ''}></FileViewer>
              </div>
              {item?.name && <p className="nameImage">{item?.image_one_name ?? ''}</p>}
            </div>
          ))}
          <div className="col-12 my-4">
            <Entry label={i18next.t('Title')} value={item?.title ?? ''} />
            <Entry
              label={i18next.t('Sub Category')}
              value={subRentCategory[item?.sub_category] ?? ''}
            />
            <Entry
              label={i18next.t('Main Category')}
              value={mainRentCategory[item?.category] ?? ''}
            />
            <Entry label={i18next.t('Bedrooms')} value={item?.bedrooms ?? ''} />
            <Entry label={i18next.t('Bathrooms')} value={item?.bathrooms ?? ''} />
            <Entry label={i18next.t('Postal Code')} value={item?.postal_code ?? ''} />
            <Entry label={i18next.t('Phone')} value={item?.telephone ?? ''} />
            <Entry label={i18next.t('Description')} value={item?.description ?? ''} />
            <Entry label={i18next.t('Note')} value={item?.note ?? ''} />
            <Entry label={i18next.t('Country')} value={item?.country ?? ''} />
            <Entry label={i18next.t('State')} value={item?.state ?? ''} />
            <Entry label={i18next.t('City')} value={item?.city ?? ''} />
            <Entry label={i18next.t('Included in rent')} value={item?.included_in_rent ?? ''} />
            <Entry label={i18next.t('Monthly rent')} value={item?.monthly_rent ?? ''} />
            <Entry label={i18next.t('Deposit')} value={item?.deposit ?? ''} />
            <Entry label={i18next.t('Street address')} value={item?.street_address ?? ''} />
            <Entry label={i18next.t('Rented Out')} value={item?.rented_out ?? ''} />
            <Entry label={i18next.t('Prom')} value={item?.prom ?? ''} />
            <Entry label={i18next.t('Gross Area')} value={item?.gross_area ?? ''} />
            <Entry label={i18next.t('Security Money')} value={item?.security_money ?? ''} />
            <Entry label={i18next.t('Use area')} value={item?.use_area ?? ''} />
            <Entry
              label={i18next.t('Amenities')}
              value={amenitiessArray?.map((item, index) => (
                <ul key={index}>
                  <li>{translateAmenties(amanetiesIcon[item])}</li>
                </ul>
              ))}
            />
            <Entry label={i18next.t('Rented from')} value={item?.rented_from ?? ''} />
            <Entry label={i18next.t('Rented to')} value={item?.rented_to ?? ''} />
            <Entry label={i18next.t('Floor')} value={item?.floor ?? ''} />
            <Entry label={i18next.t('Furnishing')} value={item?.furnishing ?? ''} />
            <Entry label={i18next.t('Energy Rating')} value={item?.energy_rating ?? ''} />
            <Entry label={i18next.t('Heating grade')} value={item?.heating_grade ?? ''} />
            <Entry label={i18next.t('Pets allowed')} value={item?.pets_allowed ?? ''} />
          </div>
        </div>
      )}
    </AdminLayout>
  );
};
