import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import { Entry } from '@/components/Elements/Table/Entry';
import { usePropertyProjectDetails } from '@/api/propertyProject/getPropertyProjectDetails';
import './property.css';
import AdminPp from '@/components/Elements/Loader/AdminPp';
import propertyCategory from '@/constants/propertyCategory';
import amanetiesIcon from '@/constants/amanetiesCategory';
import i18next from 'i18next';

export const PropertyProject = () => {
  const { id } = useParams();
  const { data, isLoading, isFetching } = usePropertyProjectDetails({ id: id ?? '1' });
  const property = data?.data;
  const categoryVal = property?.category;
  let CategoryValue = '';
  {
    Object.entries(propertyCategory).map(([key, val], i) => (
      <p key={i}>{key == categoryVal ? (CategoryValue = val) : null}</p>
    ));
  }

  const amenitiessArray = property?.amenities.split(',');

  const locations = <div dangerouslySetInnerHTML={{ __html: property?.location }} />;
  const capital_required = <div dangerouslySetInnerHTML={{ __html: property?.capital_required }} />;
  const vision = <div dangerouslySetInnerHTML={{ __html: property?.vision }} />;
  const costs_to_consider = (
    <div dangerouslySetInnerHTML={{ __html: property?.costs_to_consider }} />
  );
  const cashflow_forecast = (
    <div dangerouslySetInnerHTML={{ __html: property?.cashflow_forecast }} />
  );
  const rental = <div dangerouslySetInnerHTML={{ __html: property?.rental }} />;
  const Property_description = (
    <div dangerouslySetInnerHTML={{ __html: property?.property_description }} />
  );
  const disclaimer = <div dangerouslySetInnerHTML={{ __html: property?.disclaimer }} />;
  const property_information = (
    <div dangerouslySetInnerHTML={{ __html: property?.property_information }} />
  );

  const translateAmenties = (val: any): string => {
    return i18next.t(val);
  };

  return (
    <AdminLayout title="Property Project Details">
      {isLoading || isFetching ? (
        <AdminPp />
      ) : (
        <div className="row mt-2">
          <div className="">
            <h4 className="mb-4">Images</h4>
          </div>

          <div className="row">
            {eval(property?.image_data).map((item: any, index: number) => (
              <div className="imB" key={index}>
                <div className="image-box-n">
                  <FileViewer file={item?.image ?? ''}></FileViewer>
                </div>
                {item?.name && <p className="nameImage">{property?.image_one_name ?? ''}</p>}
              </div>
            ))}
          </div>
          <div className="col-12 mt-4 hello">
            <Entry label="Project Name" value={property?.short_title ?? ''} />
            <Entry label="Property Name" value={property?.property_name ?? ''} />
            <Entry label="Project by" value={property?.fullname ?? ''} />
            <Entry label="Category" value={CategoryValue ?? ''} />
            <Entry label={i18next.t('Location')} value={locations ?? ''} />
            <Entry label={i18next.t('Phone Number')} value={property?.phone_number ?? ''} />
            <Entry label={i18next.t('Price')} value={property?.price ?? ''} />
            <Entry label="Size" value={property?.size ?? ''} />
            <Entry label="Utility Bill" value={property?.bill_utilites ?? ''} />
            <Entry label={i18next.t('Property Description')} value={Property_description ?? ''} />
            <Entry label={i18next.t('Bedroom')} value={property?.bedroom ?? ''} />
            <Entry label={i18next.t('Bathroom')} value={property?.bathroom ?? ''} />
            <Entry label="Developer" value={property?.developer ?? ''} />
            <Entry
              label={i18next.t('Return on investment')}
              value={property?.return_on_investment ?? ''}
            />
            <Entry label={i18next.t('Cashflow PCM')} value={property?.cashflow_pcm ?? ''} />
            <Entry label="Finder Fee" value={property?.finder_fees ?? ''} />
            <Entry label="Gross income" value={property?.gross_income ?? ''} />
            <Entry label={i18next.t('Closing Fee')} value={property?.total_closing_fees ?? ''} />
            <Entry label="Ready by" value={property?.read_by ?? ''} />
            <Entry
              label={i18next.t('Amenities')}
              value={amenitiessArray?.map((item, index) => (
                <ul key={index}>
                  <li>{translateAmenties(amanetiesIcon[item])}</li>
                </ul>
              ))}
            />
            <Entry
              label={i18next.t('Property Refernce ID')}
              value={property?.property_refernce_id ?? ''}
            />
            <Entry label={i18next.t('Maintance Fee')} value={property?.maintance_fees ?? ''} />
            <Entry label={i18next.t('House Number')} value={property?.house_number ?? ''} />
            <Entry label={i18next.t('Town')} value={property?.town ?? ''} />
            <Entry label={i18next.t('Postal Code')} value={property?.postal_code ?? ''} />
            <Entry
              label={i18next.t('Rent To Landloard')}
              value={property?.rent_to_landlord ?? ''}
            />
            <Entry label={translateAmenties('Rental')} value={rental ?? ''} />
            <Entry label={i18next.t('Vision')} value={vision ?? ''} />
            <Entry label={i18next.t('Cashflow Forecast')} value={cashflow_forecast ?? ''} />
            <Entry label={i18next.t('Cost To Consider')} value={costs_to_consider ?? ''} />
            <Entry label={i18next.t('Capital Required')} value={capital_required ?? ''} />
            <Entry label={i18next.t('Disclaimer')} value={disclaimer ?? ''} />
            <Entry label={i18next.t('Property Information')} value={property_information ?? ''} />
          </div>
        </div>
      )}
    </AdminLayout>
  );
};
