import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { usePagination } from '@/hooks/usePagination';
import PropertySaleRentList from '../../components/PropertySaleRentList';
import i18next from 'i18next';

export const PropertySaleRent = () => {
  const { page, changePage } = usePagination();

  return (
    <AdminLayout title={i18next.t('Property For Sale')}>
      <PropertySaleRentList page={page} changePage={changePage} />
    </AdminLayout>
  );
};
