import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import { Entry } from '@/components/Elements/Table/Entry';
import { useGetRentAdminDetails } from '@/features/admin/api/GetRentAdmin';

import './saleproperty.css';
import propertyCategory from '@/constants/propertyCategory';
import amanetiesIcon from '@/constants/amanetiesCategory';
import subCategory from '@/constants/subCategory';
import mainCategory from '@/constants/mainCategory';
import AdminPp from '@/components/Elements/Loader/AdminPp';
import storage from '@/utils/storage';
import i18next from 'i18next';

export const PropertySaleRentDetail = () => {
  const { id } = useParams();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const { data, isLoading, isFetching } = useGetRentAdminDetails({ id: id ?? '1' });
  const item = data?.data;

  const categoryVal = item?.category;
  let CategoryValue = '';
  {
    Object.entries(propertyCategory).map(([key, val], i) => (
      <p key={i}>{key == categoryVal ? (CategoryValue = val) : null}</p>
    ));
  }

  const amenitiessArray = item?.amenities.split(',');
  return (
    <AdminLayout title="Property For Sale Detail">
      {isLoading || isFetching ? (
        <AdminPp />
      ) : (
        <div className="row mt-2">
          {eval(item?.image_data).map((item: any, index: number) => (
            <div className="imB" key={index}>
              <div className="image-box-n">
                <FileViewer file={item?.image ?? ''}></FileViewer>
              </div>
              {item?.name && <p className="nameImage">{item?.image_one_name ?? ''}</p>}
            </div>
          ))}
          <div className="col-12 my-4">
            <Entry label={i18next.t('Title')} value={item?.title ?? ''} />
            <Entry label="Youtube Url " value={item?.youtube_url ?? ''} />
            <Entry label={i18next.t('Phone')} value={item?.phone_number ?? ''} />
            <Entry label="Description " value={item?.description ?? ''} />
            <Entry label="size " value={item?.size ?? ''} />
            <Entry
              label={`{${i18next.t('Closing Fee')} ${localSymbol}`}
              value={item?.closingFee ? item?.closingFee * localCurrency : ''}
            />
            <Entry label={i18next.t('Bedrooms')} value={item?.bedrooms ?? ''} />
            <Entry label="Bathrooms " value={item?.bathrooms ?? ''} />
            <Entry
              label={`${i18next.t('Annual community fee')} ${localSymbol}`}
              value={item?.annual_community_fee ? item?.annual_community_fee * localCurrency : ''}
            />
            <Entry label="Property Reference Id " value={item?.property_reference_id ?? ''} />
            <Entry
              label={`Buyer Transfer Fee ${localSymbol}`}
              value={item?.buyer_transfer_fee ? item?.buyer_transfer_fee * localCurrency : ''}
            />
            <Entry
              label={`Seller Transfer Fee ${localSymbol}`}
              value={item?.seller_transfer_fee ? item?.seller_transfer_fee * localCurrency : ''}
            />
            <Entry
              label={`Maintenance Fee ${localSymbol}`}
              value={item?.maintenance_fee ? item?.maintenance_fee * localCurrency : ''}
            />
            <Entry label="Occupancy Status " value={item?.occupancy_status ?? ''} />
            <Entry
              label={i18next.t('Amenities')}
              value={amenitiessArray?.map((item, index) => (
                <ul key={index}>
                  <li>{amanetiesIcon[item]}</li>
                </ul>
              ))}
            />
            <Entry label="Category " value={mainCategory[item?.category] ?? ''} />
            <Entry label={i18next.t('Sub Category')} value={subCategory[item?.subcategory] ?? ''} />
            <Entry label={i18next.t('Building')} value={item?.building ?? ''} />
            <Entry label="Developer " value={item?.developer ?? ''} />
            <Entry label={i18next.t('Neighbourhood')} value={item?.neighbourhood ?? ''} />

            {item?.broker_id_number === undefined || item?.broker_id_number === '' ? null : (
              <Entry label="Broker Id number " value={item?.broker_id_number ?? ''} />
            )}
            {item?.lister_company_name === undefined || item?.lister_company_name === '' ? null : (
              <Entry label="lister Company Name " value={item?.lister_company_name ?? ''} />
            )}
            {item?.agent_name === undefined || item?.agent_name === '' ? null : (
              <Entry label="Agent Name" value={item?.agent_name ?? ''} />
            )}
            {item?.permit_number === undefined || item?.permit_number === '' ? null : (
              <Entry label="Permit Number " value={item?.permit_number ?? ''} />
            )}
            {item?.landlord_name === undefined || item?.landlord_name === '' ? null : (
              <Entry label="Landlord Name " value={item?.landlord_name ?? ''} />
            )}
            {item?.title_deed_number === undefined || item?.title_deed_number === '' ? null : (
              <Entry label="Title Deed Nnumber " value={item?.title_deed_number ?? ''} />
            )}
            {item?.pre_registration_number === undefined ||
            item?.pre_registration_number === '' ? null : (
              <Entry label="Pre Registration Number " value={item?.pre_registration_number ?? ''} />
            )}
          </div>
        </div>
      )}
    </AdminLayout>
  );
};
