import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { Button } from '@/components/Elements';
import './Subscription.css';
import { useNavigate } from 'react-router-dom';

import SubscriptionLoader from '@/components/Elements/Loader/SubscriptionLoader';
import { AgencyPlans, useAgencyPlansList } from '../../api/Subscription/agencyPlanListing';
import AgencySubscriptionItem from './AgencySubscriptionItem';

export const AdminAgencySubscription = () => {
  const navigate = useNavigate();
  const { data, isLoading, isFetching } = useAgencyPlansList({ page: '1' });
  const listing = data?.data ?? ({} as AgencyPlans[]);
  const count: number = listing?.length ?? 0;

  return (
    <>
      <AdminLayout title="Agency Subscription Management">
        {isLoading || isFetching ? (
          <SubscriptionLoader />
        ) : (
          <>
            <div className="add-btn-sub">
              {count >= 3 ? null : (
                <>
                  <Button
                    onClick={() => {
                      navigate('/admin/agency-add-subscription');
                    }}
                  >
                    + Add
                  </Button>
                </>
              )}
            </div>

            <div className="row">
              {listing?.slice(0, 4).map((item, index) => (
                <AgencySubscriptionItem item={item} key={index} />
              ))}
            </div>
          </>
        )}
      </AdminLayout>
    </>
  );
};
