import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { Button } from '@/components/Elements';
import './Subscription.css';
import { useNavigate } from 'react-router-dom';

import SubscriptionLoader from '@/components/Elements/Loader/SubscriptionLoader';
import { useLawyerSubScription } from '../../api/Subscription/getLawyerSubscription';
import EditSubscriptionItem from './EditSubscriptionItem';

export const AdminLawyerSubscription = () => {
  const navigate = useNavigate();
  const { data: listing, isLoading, isFetching } = useLawyerSubScription({ page: '1' });
  const count: number = listing?.length ?? 0;

  return (
    <>
      <AdminLayout title="Lawyer Subscription Management">
        {isLoading || isFetching ? (
          <SubscriptionLoader />
        ) : (
          <>
            <div className="add-btn-sub">
              {count >= 3 ? null : (
                <>
                  <Button
                    onClick={() => {
                      navigate('/admin/lawyer-add-subscription');
                    }}
                  >
                    + Add
                  </Button>
                </>
              )}
            </div>

            <div className="row">
              {listing?.slice(0, 4).map((item, index) => (
                <EditSubscriptionItem item={item} key={index} />
              ))}
            </div>
          </>
        )}
      </AdminLayout>
    </>
  );
};
