import React, { useEffect, useState } from 'react';
import './Subscription.css';
import { useNavigate } from 'react-router-dom';
import ReactSwitch from 'react-switch';
import { Subscription } from '@/types';
import { changeLawyerStatus } from '../../api/Subscription/changeLawyerStatus';

function EditSubscriptionItem({ item }: { item: Subscription }) {
  const [checked, setChecked] = useState<boolean>(item.status);
  const [status, setstatus] = useState<boolean>();
  const id = item.id;
  const handleChange = (val: boolean) => {
    setChecked(val);
    gotoContract();
  };
  useEffect(() => {
    setstatus(!checked);
  }, [checked]);

  const navigate = useNavigate();

  const gotoContract = async () => {
    await changeLawyerStatus({ id, status });
  };

  return (
    <>
      <div className="main-item-box col-4 col-md-4">
        <div className="box-shadows">
          <div className="row lines">
            <div className="col-md-6 col-6">
              <span className="sub-name">{item.plan_name}</span>
            </div>
            <div className="col-md-6 col-6 right">
              <ReactSwitch checked={checked} onChange={handleChange} />

              <span
                role="button"
                tabIndex={-1}
                onKeyDown={() => navigate(`/admin/lawyer-edit-subscription/${item.id}`)}
                onClick={() => navigate(`/admin/lawyer-edit-subscription/${item.id}`)}
                className="icon me-2 col-md-6"
                title="View"
              >
                <i className="fa-solid fa-pencil"></i>
              </span>
            </div>
          </div>
          <p className="sub-description">{item.plan_description}</p>
          <div className="row">
            <div className="col-md-6 col-6 price">{item.price}</div>
            <div className="col-md-6 col-6 valid">{item.plan_validity} days</div>
          </div>
        </div>
      </div>
    </>
  );
}

export default EditSubscriptionItem;
