import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { Button } from '@/components/Elements';
import './Subscription.css';
import { useNavigate } from 'react-router-dom';

import { useSubscription } from '@/features/admin/api/Subscription/GetSubscription';
import SubscriptionLoader from '@/components/Elements/Loader/SubscriptionLoader';
import SubscriptionItem from './SubscriptionItem';

export const Subscription = () => {
  const navigate = useNavigate();
  const { data: listing, isLoading, isFetching } = useSubscription({ page: '1' });
  const count = listing?.length ?? 0;

  return (
    <>
      <AdminLayout title="Subscription Management">
        {isLoading || isFetching ? (
          <SubscriptionLoader />
        ) : (
          <>
            <div className="add-btn-sub">
              {count >= 3 ? null : (
                <>
                  <Button
                    onClick={() => {
                      navigate('/admin/add-subscription');
                    }}
                  >
                    + Add
                  </Button>
                </>
              )}
            </div>

            <div className="row">
              {listing?.slice(0, 3).map((item, index) => (
                <SubscriptionItem item={item} key={index} />
              ))}
            </div>
          </>
        )}
      </AdminLayout>
    </>
  );
};
