import React, { useEffect, useState } from 'react';
import './Subscription.css';
import { useNavigate } from 'react-router-dom';
import ReactSwitch from 'react-switch';
import { Subscription } from '@/types';
import { changeSubscriptionStatus } from '../../api/Subscription/changeSubscriptionStatus';
import i18next from 'i18next';

function SubscriptionItem({ item }: { item: Subscription }) {
  const [checked, setChecked] = useState<boolean>(item.status);
  const [status, setstatus] = useState<boolean>();
  const id = item.id;
  const handleChange = (val: boolean) => {
    setChecked(val);
    gotoContract();
  };
  useEffect(() => {
    setstatus(!checked);
  }, [checked]);

  const navigate = useNavigate();

  const gotoContract = async () => {
    await changeSubscriptionStatus({ id, status });
  };

  return (
    <>
      <div className="main-item-box col-4 col-md-4">
        <div className="box-shadows">
          <div className="row lines">
            <div className="col-md-6 col-6">
              <span className="sub-name">{item.plan_name}</span>
            </div>
            <div className="col-md-6 col-6 right">
              <ReactSwitch checked={checked} onChange={handleChange} />

              <span
                role="button"
                tabIndex={-1}
                onKeyDown={() => navigate(`/admin/edit-subscription/${item.id}`)}
                onClick={() => navigate(`/admin/edit-subscription/${item.id}`)}
                className="icon me-2 col-md-6"
                title="View"
              >
                <i className="fa-solid fa-pencil"></i>
              </span>
            </div>
          </div>
          <p className="sub-description">{item.plan_description}</p>
          <div className="row">
            <div className="col-md-8 col-8 head">Property Count</div>
            <div className="col-md-2 col-2 package">
              {item.property_count > 5 ? 'Unlimited' : item.property_count}
            </div>
          </div>
          <div className="row">
            <div className="col-md-8 col-8 head">Package Type</div>
            <div className="col-md-2 col-2 package">{item.package_type}</div>
          </div>

          {item?.discount !== 0 && item?.discount !== null && (
            <div className="row">
              <div className="col-md-8 col-8 head">Discount</div>
              <div className="col-md-2 col-2 package">{item.discount}%</div>
            </div>
          )}

          <div className="row">
            <div className="col-md-8 col-8 head">{i18next.t('Price')}</div>
            <div className="col-md-2 col-2 package">{item.price}</div>
          </div>
          <div className="row">
            <div className="col-md-8 col-8 head">Validity</div>
            <div className="col-md-2 col-2 package">{item.plan_validity}</div>
          </div>
        </div>
      </div>
    </>
  );
}

export default SubscriptionItem;
