import React, { useEffect, useState } from 'react';
import { Button, Table, TableColumn } from '@/components/Elements';
import { useNavigate } from 'react-router-dom';
import { useUserRoles } from '@/features/admin/api/userRoleManagement/getUserRoles';
import { deleteFaq } from '@/features/admin/api/deleteFaq';
import { SubAdminData } from '@/types';
import './RoleManagement.css';
import { useNotificationStore } from '@/stores/notifications';

import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import TableLoader from '@/components/Elements/Loader/TableLoader';

type Content = {
  id: string;
  firstName: string;
  lastName: string;
  role: string;
};

const UserRolesListing = ({
  page,
  changePage,
}: {
  page: string;
  changePage: (page: string) => void;
}) => {
  const [open, setOpen] = useState(false);
  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);
  const navigate = useNavigate();
  const { data, refetch } = useUserRoles({ page });
  const [datId, setDataId] = useState('');
  const dataLength = data?.data.length;

  const deleteSelected = async () => {
    await deleteFaq(datId);
    refetch();
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'info',
      message: 'Role permission deleted successfully!',
    });
    onCloseModal();
  };
  useEffect(() => {
    refetch();
  }, [page, refetch]);
  const columns: TableColumn<Content>[] = [
    {
      title: 'First Name',
      field: 'firstName',
      Cell({ entry: { firstName } }) {
        return <span>{firstName}</span>;
      },
    },
    {
      title: 'Last Name',
      field: 'lastName',
      Cell({ entry: { lastName } }) {
        return <span>{lastName}</span>;
      },
    },
    {
      title: 'Role Assigned',
      field: 'role',
      Cell({ entry: { role } }) {
        return <span>{role}</span>;
      },
    },
    {
      title: 'Action',
      field: 'id',
      Cell({ entry: { id } }) {
        return (
          <>
            <span
              role="button"
              tabIndex={-1}
              onKeyDown={() => navigate(`/admin/edit-user-roles/${id}`)}
              onClick={() => navigate(`/admin/edit-user-roles/${id}`)}
              className="icon me-2 buttons2"
              title="Edit"
            >
              <i className="fa-solid fa-pencil"></i>
            </span>
            {/* <span
              role="button"
              tabIndex={-1}
              onKeyDown={() => setDataId(`${id}`)}
              onClick={() => {
                setDataId(`${id}`);
                onOpenModal();
              }}
              className="icon me-2 buttons2"
              title="Edit"
            >
              <i className="fa-solid fa-trash-can"></i>
            </span> */}
          </>
        );
      },
    },
  ];
  return (
    <div>
      <Button
        className="addFaqs"
        onClick={() => {
          navigate('/admin/add-user-roles');
        }}
      >
        Add Users +
      </Button>
      {data?.data ? (
        <Table<SubAdminData>
          data={data?.data ?? []}
          columns={columns}
          page={parseInt(page)}
          changePage={changePage}
          total={data?.total ?? 0}
        />
      ) : (
        <TableLoader />
      )}
      <Modal open={open} onClose={onCloseModal} center>
        <section className="model-datas">
          <p>Are you Sure you want to delete the role</p>
        </section>
        <p className="btn-lines">
          <Button onClick={deleteSelected}>Delete</Button>
        </p>
      </Modal>
    </div>
  );
};

export default UserRolesListing;
