import React, { useEffect, useState } from 'react';
import { Button, Table, TableColumn } from '@/components/Elements';
import { useNavigate } from 'react-router-dom';
import { useRolesListing } from '@/features/admin/api/getRolesListing';
import { deleteFaq } from '@/features/admin/api/deleteFaq';
import { RoleContent } from '@/types';
import './RoleManagement.css';
import { useNotificationStore } from '@/stores/notifications';
import TableLoader from '@/components/Elements/Loader/TableLoader';

import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';

type Content = {
  id: string;
  role_name: string;
};

const RolesListing = ({
  page,
  changePage,
}: {
  page: string;
  changePage: (page: string) => void;
}) => {
  const [open, setOpen] = useState(false);
  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);
  const navigate = useNavigate();
  const { data, refetch, isLoading, isFetching, isRefetching } = useRolesListing({ page });
  const [datId, setDataId] = useState('');

  const deleteSelected = async () => {
    await deleteFaq(datId);
    refetch();
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'info',
      message: 'Role permission deleted successfully!',
    });
    onCloseModal();
  };
  useEffect(() => {
    refetch();
  }, [page, refetch]);
  const columns: TableColumn<Content>[] = [
    {
      title: 'Role Title',
      field: 'role_name',
      Cell({ entry: { role_name } }) {
        return <span>{role_name}</span>;
      },
    },
    {
      title: 'Action',
      field: 'id',
      Cell({ entry: { id } }) {
        return (
          <>
            <span
              role="button"
              tabIndex={-1}
              onKeyDown={() => navigate(`/admin/add-role-content/${id}`)}
              onClick={() => navigate(`/admin/add-role-content/${id}`)}
              className="icon me-2 buttons2"
              title="Edit"
            >
              <i className="fa-solid fa-pencil"></i>
            </span>
            {/* <span
              role="button"
              tabIndex={-1}
              onKeyDown={() => setDataId(`${id}`)}
              onClick={() => {
                setDataId(`${id}`);
                onOpenModal();
              }}
              className="icon me-2 buttons2"
              title="Edit"
            >
              <i className="fa-solid fa-trash-can"></i>
            </span> */}
          </>
        );
      },
    },
  ];
  return (
    <>
      {isLoading && isFetching && isRefetching ? (
        <TableLoader />
      ) : (
        <div>
          <Button
            className="addFaqs"
            onClick={() => {
              navigate('/admin/add-role-content');
            }}
          >
            Add Roles +
          </Button>

          {data?.data ? (
            <Table<RoleContent>
              data={data?.data ?? []}
              columns={columns}
              page={parseInt(page)}
              changePage={changePage}
              total={data?.total ?? 0}
            />
          ) : (
            <TableLoader />
          )}
          <Modal open={open} onClose={onCloseModal} center>
            <section className="model-datas">
              <p>Are you Sure you want to delete the role</p>
            </section>
            <p className="btn-lines">
              <Button onClick={deleteSelected}>Delete</Button>
            </p>
          </Modal>
        </div>
      )}
    </>
  );
};

export default RolesListing;
