import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Subscription } from '@/types';
export const getAgencySubScription = (pagination: PaginationQuery): Promise<Subscription[]> => {
  return axios.get(url('/subscription-api/agency-plan-listing', pagination));
};
type QueryFnType = typeof getAgencySubScription;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useAgencySubScription = ({
  config,
  page_per_data = '10',
  page,
}: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['agencylisting'],
    queryFn: () => getAgencySubScription({ page_per_data, page }),
  });
};
