import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { AxiosResponse } from 'axios';
import { useQuery } from 'react-query';

export type CurrentPlan = {
  id: string;
  plan_id: string;
  plan_name: string;
  sub_start_date: string;
  sub_expiry_date: string;
  is_active: boolean;
  plan_description: string;
  price: string;
  plan_validity: string;
  status: boolean;
};

export const getMyPlan = (): Promise<AxiosResponse<CurrentPlan>> => {
  return axios.get('subscription-api/agency-my-subscription-plan');
};

type QueryFnType = typeof getMyPlan;

type useMyPlan = {
  config?: QueryConfig<QueryFnType>;
};

export const useMyPlan = ({ config }: useMyPlan = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Agency-current-plan'],
    queryFn: () => getMyPlan(),
  });
};
