import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { TableResponse } from '@/types';
import { useQuery } from 'react-query';

export type AgencyRatingList = {
  id: string;
  customer_name: string;
  customer_image: string;
  rating: number;
  reviews: string;
  rating_date: Date | string;
};

export const getRatingList = (): Promise<TableResponse<AgencyRatingList>> => {
  return axios.get('agency-api/agency-get-my-ratings');
};

type QueryFnType = typeof getRatingList;

type useRatingList = {
  config?: QueryConfig<QueryFnType>;
};

export const useRatingList = ({ config }: useRatingList) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['agency-ratings'],
    queryFn: () => getRatingList(),
  });
};
