import { axios } from '@/lib/axios';
import { useQuery } from 'react-query';
import { ExtractFnReturnType } from '@/lib/react-query';

export const leadApi = (): Promise<any> => {
  return axios.get('/agency-api/agency-customer-leads');
};

type QueryFnType = typeof leadApi;

export const useAgencyLead = () => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    queryKey: ['agencyleads'],
    queryFn: leadApi,
  });
};
