import React, { useEffect, useState } from 'react';
import { Button, Table } from '@/components/Elements';
import { Inquiry } from '@/types';
import TableLoader from '@/components/Elements/Loader/TableLoader';
import { ConfirmDialogWithButton } from '@/components/Elements/ConfirmationDialog/ConfirmDialogWithButton';

import { useNotificationStore } from '@/stores/notifications';
import { useAgencyInquiry } from '@/api/AgencyApi/getAgencyrequest';
import { changeRequestStatus } from '@/api/AgencyApi/changeRequestStatus';
import i18next from 'i18next';

export const AgencyRequestLIst = ({
  page,
  changePage,
}: {
  page: string;
  changePage: (page: string) => void;
}) => {
  const { data, refetch, isLoading, isFetching } = useAgencyInquiry({});

  const [loading, setLoading] = useState(false);
  const [moddedInquiry, setModdedInquiry] = useState<any>([]);

  useEffect(() => {
    let inquiriesMod: any = [];

    inquiriesMod = data?.data.map((item) => {
      const inquiry: any = {};
      inquiry.id = item.id;
      inquiry.name = item.name;
      inquiry.mobile_number = item.mobile_number;
      inquiry.email = item.email;
      inquiry.property_type = item.property_type;
      inquiry.type = item.type;
      inquiry.status = item.status;
      inquiry.is_requested = item.is_requested;

      return inquiry;
    });
    setModdedInquiry(inquiriesMod);
  }, [data]);

  useEffect(() => {
    refetch();
  }, [page, refetch]);

  const changeStatusAction = async (id: string) => {
    try {
      setLoading(true);
      await changeRequestStatus(id);
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have approved this request successfully!',
      });
      refetch();
    } finally {
      setLoading(false);
    }
  };

  return (
    <>
      <div className="inquiry-table-content">
        {isLoading || isFetching ? (
          <TableLoader />
        ) : (
          <Table<Inquiry>
            page={parseInt(page)}
            changePage={changePage}
            total={data?.total ?? 1}
            data={moddedInquiry ?? []}
            columns={[
              { title: `${i18next.t('Name')}`, field: 'name' },
              { title: 'Telephone', field: 'mobile_number' },
              { title: `${i18next.t('Email')}`, field: 'email' },
              { title: `${i18next.t('Property Type')}`, field: 'property_type' },
              { title: 'Status', field: 'status' },
              {
                title: 'Action',
                field: 'is_requested',
                Cell({ entry: { id, is_requested } }) {
                  return (
                    <>
                      {is_requested === true ? (
                        <Button size="sm" disabled>
                          Approved
                        </Button>
                      ) : (
                        <ConfirmDialogWithButton
                          triggerButton={<Button variant="outlineDark">Approve</Button>}
                          confirmButton={
                            <Button
                              isLoading={loading}
                              onClick={() => changeStatusAction(id)}
                              variant="primary"
                            >
                              Approve
                            </Button>
                          }
                          title="Confirm"
                          icon="info"
                          body="Are you sure you want to approve this request?"
                        />
                      )}
                    </>
                  );
                },
              },
              // {
              //   title: 'Action',
              //   field: 'status',
              //   Cell({ entry: { id, type } }) {
              //     return (
              //       <>
              //         <span
              //           role="button"
              //           tabIndex={-1}
              //           onKeyDown={() => navigate(`/admin/inquiry/${id}&type=${type}`)}
              //           onClick={() => navigate(`/admin/inquiry/${id}&type=${type}`)}
              //           className="icon me-2"
              //           title="View"
              //         >
              //           <i className="fa-regular fa-eye" />
              //         </span>
              //       </>
              //     );
              //   },
              // },
            ]}
          />
        )}
      </div>
    </>
  );
};
