import React, { useEffect, useState } from 'react';
import { AdminLayout } from '@/components/Layout';
import 'react-circular-progressbar/dist/styles.css';
import './Dashboard.css';
import building1 from '@/assets/building1.png';
import building2 from '@/assets/building2.png';
import building4 from '@/assets/building4.png';
import { useNavigate } from 'react-router-dom';
import storage from '@/utils/storage';
import DashboardLoader from '@/components/Elements/Loader/DashboardLoader';
import { Table } from '@/components/Elements';
import { usePagination } from '@/hooks/usePagination';
import { PropertyRequest } from './types/dashboard';
import i18next from 'i18next';

export const AgencyDashboard = () => {
  const navigate = useNavigate();
  const { page, changePage } = usePagination();
  const [user, setUser] = useState([]);
  const [loading, setLoading] = useState<boolean>(false);
  const token = storage.getToken();
  const axiosUrl = process.env.REACT_APP_API_URL;

  const fetchData = () => {
    setLoading(true);
    const headers = { Authorization: `${token}` };
    return fetch(`${axiosUrl}/agency-api/agency-dashboard`, { headers })
      .then((response) => response.json())
      .then((data) => {
        setUser(data);
        if (user) {
          setLoading(false);
        }
      });
  };

  useEffect(() => {
    fetchData();
  }, []);
  console.log(loading);
  return (
    <>
      {!loading ? (
        <AdminLayout title={i18next.t('Dashboard')}>
          <section className="dashboard-home">
            <div className="row">
              <button
                onClick={() => navigate('/property-for-sale')}
                className="outer-box col-md-4 col-6 hola"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.total_requests}</h4>
                      <h6>Total Requests</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building1} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                onClick={() => navigate('/property-for-rent')}
                className="outer-box col-md-4 col-6 hola"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.approved_requests}</h4>

                      <h6>Approved Requests</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building2} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                onClick={() => navigate('/housing-for-rent')}
                className="outer-box col-md-4 col-6 hola"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.total_lead}</h4>

                      <h6>Total Lead</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building4} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
            </div>

            {/* <div className="col-8 my-2">
            <div className="das-head mt-4">All Leads Data</div>
              <div className="item-box border p-3 position-relative">
                <div className="row mydeals-rw">
                  {user?.allLeadsData?.map((item: any) => {
                    return (
                      <>
                        <div className="col-12 col-md-12 col-lg-4">
                          <Image imagefallback={item.image_data[0].image} />
                        </div>
                        <div className="col-12 col-md-12 col-lg-8">
                          <div className="item-boxs">
                            <span className="crated-span">{timeFromNow(item.created_date)} ago.</span>
                            <h5>{trimTwenty(item?.property_name)}</h5>
                            <p className="hr2">
                              <i className="fa-solid fa-location-dot"></i>
                              {trimThirty(item?.town)}
                            </p>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Purchase Price</p>
                              <p className="rightSd col-4 col-md-4">{formatMoney(item.price)}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Return On Investment</p>
                              <p className="rightSd col-4 col-md-4">{formatMoney(item.return_on_investment)}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Cashflow PCM</p>
                              <p className="rightSd col-4 col-md-4">{formatMoney(item.cashflow_pcm)}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Finder Fees</p>
                              <p className="rightSd col-4 col-md-4">{formatMoney(item.finder_fees)}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Gross Income</p>
                              <p className="rightSd col-4 col-md-4">{formatMoney(item.gross_income)}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Rent to Landloard</p>
                              <p className="rightSd col-4 col-md-4">{formatMoney(item.rent_to_landlord)}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Return on Investment</p>
                              <p className="rightSd col-4 col-md-4">{formatMoney(item.return_on_investment)}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Telephone</p>
                              <p className="rightSd col-4 col-md-4">{item.telephone}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Type</p>
                              <p className="rightSd col-4 col-md-4">{item.type}</p>
                            </div>
                            
                          </div>
                        </div>
                      </>
                    )
                  })}
                </div>

              </div>

            </div> */}

            <div className="row dashbords">
              <div className="col-12 oUtr">
                <div className="in-boxx">
                  <div className="das-head">Property Request</div>
                  <Table<PropertyRequest>
                    page={parseInt(page)}
                    total={1}
                    changePage={changePage}
                    data={user?.property_request ?? []}
                    columns={[
                      { title: `${i18next.t('Name')}`, field: 'name' },
                      { title: `${i18next.t('Email')}`, field: 'email' },
                      { title: `${i18next.t('Phone')}`, field: 'mobile_number' },
                      { title: `${i18next.t('Property Type')}`, field: 'property_type' },
                      { title: 'Status', field: 'status' },
                    ]}
                  />
                </div>
              </div>
            </div>
          </section>
        </AdminLayout>
      ) : (
        <div className="row spins">
          <DashboardLoader />
        </div>
      )}
    </>
  );
};
