import React, { useEffect, useState } from 'react';
import { AdminLayout } from '@/components/Layout';
import { usePagination } from '@/hooks/usePagination';
import { AgencyRequestLIst } from '../../components/AgencyRequestLIst';
import { useAuth } from '@/lib/auth';
import { SubscriptionType } from '../SubscriptionAgency/SubscriptionType';
import TableLoader from '@/components/Elements/Loader/TableLoader';

export const Inquiries = () => {
  const [loading, setLoading] = useState<boolean>(false);
  const { page, changePage } = usePagination();
  const { user, refetchUser } = useAuth();

  useEffect(() => {
    setLoading(true);
    refetchUser();
    setTimeout(() => {
      setLoading(false);
    }, 1000);
  }, [user?.has_subscription]);

  return (
    <AdminLayout title="Agency Request List">
      {loading && <TableLoader />}
      {!loading ? (
        user?.has_subscription === true ? (
          <AgencyRequestLIst page={page} changePage={changePage} />
        ) : (
          <SubscriptionType />
        )
      ) : null}
    </AdminLayout>
  );
};
