import React, { useEffect, useState } from 'react';
import { useAgencyLead } from '../../api/leadsApi';
import { Image } from '@/components/Elements';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { formatMoney, timeFromNow, trimThirty, trimTwenty } from '@/utils/format';
import i18next from 'i18next';

const AgencyLeadList = () => {
  const { data, isLoading } = useAgencyLead();
  const [notes, setNot] = useState(false);
  useEffect(() => {
    if (data?.data?.length === 0) {
      setNot(true);
    }
  }, [data?.data]);
  return (
    <>
      {isLoading ? (
        <MyListingLoader />
      ) : (
        <>
          {notes ? (
            <h5 className="makeCenter">No leads found for the agency !</h5>
          ) : (
            <div className="col-12 my-2 col-md-6">
              <div className="item-box border p-2 position-relative">
                <div className="row mydeals-rw">
                  {data?.data.map((item: any) => {
                    return (
                      <>
                        <div className="col-12 col-md-12 col-lg-4">
                          <Image imagefallback={item.image_data[0].image} />
                        </div>
                        <div className="col-12 col-md-12 col-lg-8">
                          <div className="item-boxs">
                            <span className="crated-span">
                              {timeFromNow(item.created_date)} ago.
                            </span>
                            <h5>{trimTwenty(item?.property_name)}</h5>
                            <p className="hr2">
                              <i className="fa-solid fa-location-dot"></i>
                              {trimThirty(item?.town)}
                            </p>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">{i18next.t('Purchase price')}</p>
                              <p className="rightSd col-4 col-md-4">{formatMoney(item.price)}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">
                                {i18next.t('Return On Investment')}
                              </p>
                              <p className="rightSd col-4 col-md-4">
                                {formatMoney(item.return_on_investment)}
                              </p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">{i18next.t('Cashflow PCM')}</p>
                              <p className="rightSd col-4 col-md-4">
                                {formatMoney(item.cashflow_pcm)}
                              </p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Finder Fees</p>
                              <p className="rightSd col-4 col-md-4">
                                {formatMoney(item.finder_fees)}
                              </p>
                            </div>
                          </div>
                        </div>
                      </>
                    );
                  })}
                </div>
              </div>
            </div>
          )}
        </>
      )}
    </>
  );
};
export default AgencyLeadList;
